/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.logic;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.BooleanAccess;
import net.imglib2.img.basictypeaccess.array.BooleanArray;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class NativeBoolType
extends AbstractIntegerType<NativeBoolType>
implements BooleanType<NativeBoolType>,
NativeType<NativeBoolType> {
    final Index i = new Index();
    protected final NativeImg<?, ? extends BooleanAccess> img;
    protected BooleanAccess dataAccess;
    private static final NativeTypeFactory<NativeBoolType, BooleanAccess> typeFactory = NativeTypeFactory.BOOLEAN(NativeBoolType::new);

    public NativeBoolType(NativeImg<?, ? extends BooleanAccess> boolStorage) {
        this.img = boolStorage;
    }

    public NativeBoolType(boolean value) {
        this.img = null;
        this.dataAccess = new BooleanArray(1);
        this.set(value);
    }

    public NativeBoolType(BooleanAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public NativeBoolType() {
        this(false);
    }

    @Override
    public NativeTypeFactory<NativeBoolType, BooleanAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public NativeBoolType duplicateTypeOnSameNativeImg() {
        return new NativeBoolType(this.img);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public boolean get() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Override
    public void set(boolean f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void set(NativeBoolType c) {
        this.set(c.get());
    }

    @Override
    public void and(NativeBoolType c) {
        this.set(this.get() && c.get());
    }

    @Override
    public void or(NativeBoolType c) {
        this.set(this.get() || c.get());
    }

    @Override
    public void xor(NativeBoolType c) {
        this.set(this.get() ^ c.get());
    }

    @Override
    public void not() {
        this.set(!this.get());
    }

    @Override
    public void add(NativeBoolType c) {
        this.xor(c);
    }

    @Override
    public void div(NativeBoolType c) {
        this.and(c);
    }

    @Override
    public void mul(NativeBoolType c) {
        this.and(c);
    }

    @Override
    public void sub(NativeBoolType c) {
        this.xor(c);
    }

    @Override
    public void mul(float c) {
        if (c >= 0.5f) {
            this.set(this.get());
        } else {
            this.set(false);
        }
    }

    @Override
    public void mul(double c) {
        if (c >= 0.5) {
            this.set(this.get());
        } else {
            this.set(false);
        }
    }

    @Override
    public void setOne() {
        this.set(true);
    }

    @Override
    public void setZero() {
        this.set(false);
    }

    @Override
    public void inc() {
        this.not();
    }

    @Override
    public void dec() {
        this.not();
    }

    @Override
    public String toString() {
        return "" + this.get();
    }

    @Override
    public int getBitsPerPixel() {
        return 8;
    }

    @Override
    public boolean valueEquals(NativeBoolType t) {
        return this.get() == t.get();
    }

    @Override
    public boolean equals(Object obj) {
        return Util.valueEqualsObject(this, obj);
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.get());
    }

    @Override
    public int compareTo(NativeBoolType c) {
        return Boolean.compare(this.get(), c.get());
    }

    @Override
    public NativeBoolType createVariable() {
        return new NativeBoolType();
    }

    @Override
    public NativeBoolType copy() {
        return new NativeBoolType(this.dataAccess != null ? this.get() : false);
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.get() ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public void setInteger(int f) {
        this.set(f > 0);
    }

    @Override
    public void setInteger(long f) {
        this.set(f > 0L);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.compareTo(BigInteger.ZERO) > 0);
    }
}

