/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.GenericIntType;

public class IntType
extends GenericIntType<IntType> {
    private static final NativeTypeFactory<IntType, IntAccess> typeFactory = NativeTypeFactory.INT(IntType::new);

    public IntType(NativeImg<?, ? extends IntAccess> img) {
        super(img);
    }

    public IntType(int value) {
        super(value);
    }

    public IntType(IntAccess access) {
        super(access);
    }

    public IntType() {
        super(0);
    }

    @Override
    public IntType duplicateTypeOnSameNativeImg() {
        return new IntType(this.img);
    }

    @Override
    public NativeTypeFactory<IntType, IntAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    public int get() {
        return this.getInt();
    }

    @Override
    public void set(int b) {
        this.setInt(b);
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set((int)f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.intValue());
    }

    @Override
    public double getMaxValue() {
        return 2.147483647E9;
    }

    @Override
    public double getMinValue() {
        return -2.147483648E9;
    }

    @Override
    public IntType createVariable() {
        return new IntType(0);
    }

    @Override
    public IntType copy() {
        return new IntType(this.dataAccess != null ? this.get() : 0);
    }
}

