/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.text.DecimalFormat;

public class StopWatch {
    private long time = System.nanoTime();
    private long total = 0L;
    private long started = 0L;
    private boolean running = false;
    private static DecimalFormat format = new DecimalFormat("#0.000");

    private StopWatch() {
    }

    public static StopWatch createStopped() {
        return new StopWatch();
    }

    public static StopWatch createAndStart() {
        StopWatch sw = new StopWatch();
        sw.start();
        return sw;
    }

    private long safeNanos() {
        long t = System.nanoTime();
        if (t > this.time) {
            this.time = t;
        }
        return this.time;
    }

    public synchronized void start() {
        if (this.running) {
            this.stop();
        }
        this.started = this.safeNanos();
        this.running = true;
    }

    public synchronized void stop() {
        if (this.running) {
            this.total += this.safeNanos() - this.started;
        }
        this.running = false;
    }

    public synchronized long nanoTime() {
        if (this.running) {
            return this.total + this.safeNanos() - this.started;
        }
        return this.total;
    }

    public double seconds() {
        return (double)this.nanoTime() * 1.0E-9;
    }

    public String toString() {
        return StopWatch.secondsToString(this.seconds());
    }

    public static String secondsToString(double seconds) {
        double abs = Math.abs(seconds);
        if (abs < 1.0E-6) {
            return format.format(seconds * 1.0E9) + " ns";
        }
        if (abs < 0.001) {
            return format.format(seconds * 1000000.0) + " \u00b5s";
        }
        if (abs < 1.0) {
            return format.format(seconds * 1000.0) + " ms";
        }
        return format.format(seconds) + " s";
    }
}

