/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.io.File;
import sc.fiji.i5d.plugin.HypervolumeOpenerDialog;
import sc.fiji.i5d.util.NumberedStringSorter;

public class Hypervolume_Opener
implements PlugIn {
    private static boolean grayscale;
    private static double scale;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private FileInfo fi;
    private Calibration cal;
    private String info1;

    public void run(String arg) {
        double max;
        double min;
        ImageStack stack;
        block37: {
            OpenDialog od = new OpenDialog("Open Sequence of Image Stacks...", arg);
            String directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return;
            }
            String[] list = new File(directory).list();
            if (list == null) {
                return;
            }
            NumberedStringSorter.sort(list);
            if (IJ.debugMode) {
                IJ.log((String)("Hypervolume_Opener: " + directory + " (" + list.length + " files)"));
            }
            int width = 0;
            int height = 0;
            int type = 0;
            int depth = 0;
            stack = null;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            IJ.register(Hypervolume_Opener.class);
            try {
                ImagePlus imp = new Opener().openImage(directory, name);
                if (imp != null) {
                    width = imp.getWidth();
                    height = imp.getHeight();
                    depth = imp.getStackSize();
                    type = imp.getType();
                    this.fi = imp.getOriginalFileInfo();
                    this.cal = imp.getCalibration();
                } else {
                    for (int i = 0; i < list.length; ++i) {
                        if (list[i].endsWith(".txt") || list[i].endsWith(".roi") || (imp = new Opener().openImage(directory, list[i])) == null) continue;
                        width = imp.getWidth();
                        height = imp.getHeight();
                        depth = imp.getStackSize();
                        type = imp.getType();
                        this.fi = imp.getOriginalFileInfo();
                        this.cal = imp.getCalibration();
                        break;
                    }
                }
                if (imp != null && !this.showDialog(imp, list)) {
                    return;
                }
                if (width == 0) {
                    IJ.showMessage((String)"Import Sequence", (String)"This folder does not appear to contain any TIFF,\nJPEG, BMP, DICOM, GIF, FITS or PGM files.");
                    return;
                }
                if (this.n < 1) {
                    this.n = list.length;
                }
                if (this.start < 1 || this.start > list.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > list.length) {
                    this.n = list.length - this.start + 1;
                }
                int filteredImages = this.n;
                if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                    this.filter = null;
                }
                if (this.filter != null) {
                    filteredImages = 0;
                    for (int i = this.start - 1; i < list.length; ++i) {
                        if (list[i].indexOf(this.filter) < 0) continue;
                        ++filteredImages;
                    }
                    if (filteredImages == 0) {
                        IJ.error((String)("None of the " + this.n + " files contain\n the string '" + this.filter + "' in their name."));
                        return;
                    }
                }
                if (filteredImages < this.n) {
                    this.n = filteredImages;
                }
                int count = 0;
                int counter = 0;
                for (int i = this.start - 1; i < list.length; ++i) {
                    if (list[i].endsWith(".txt") || list[i].endsWith(".roi") || this.filter != null && list[i].indexOf(this.filter) < 0 || ++counter < this.start || (counter - this.start) % this.increment != 0) continue;
                    imp = new Opener().openImage(directory, list[i]);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        type = imp.getType();
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = scale < 100.0 ? new ImageStack((int)((double)width * scale / 100.0), (int)((double)height * scale / 100.0), cm) : new ImageStack(width, height, cm);
                        this.info1 = (String)imp.getProperty("Info");
                    }
                    if (imp == null) {
                        if (!list[i].startsWith(".")) {
                            IJ.log((String)(list[i] + ": unable to open"));
                        }
                    } else if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.log((String)(list[i] + ": wrong dimensions"));
                    } else if (imp.getType() != type) {
                        IJ.log((String)(list[i] + ": wrong type"));
                    } else {
                        IJ.showStatus((String)(++count + "/" + this.n));
                        IJ.showProgress((double)((double)count / (double)this.n));
                        depth = imp.getStackSize();
                        for (int iSlice = 1; iSlice <= depth; ++iSlice) {
                            imp.setSlice(iSlice);
                            ImageProcessor ip = imp.getProcessor();
                            if (grayscale) {
                                ImageConverter ic = new ImageConverter(imp);
                                ic.convertToGray8();
                                ip = imp.getProcessor();
                            }
                            if (scale < 100.0) {
                                ip = ip.resize((int)((double)width * scale / 100.0), (int)((double)height * scale / 100.0));
                            }
                            if (ip.getMin() < min) {
                                min = ip.getMin();
                            }
                            if (ip.getMax() > max) {
                                max = ip.getMax();
                            }
                            String label = imp.getTitle();
                            String info = (String)imp.getProperty("Info");
                            if (info != null) {
                                label = label + "\n" + info;
                            }
                            stack.addSlice(label, ip);
                        }
                    }
                    if (count < this.n) {
                        continue;
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory((String)"Hypervolume_Opener");
                if (stack == null) break block37;
                stack.trim();
            }
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus("Stack", stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.setFileInfo(this.fi);
            imp2.setCalibration(this.cal);
            if (imp2.getStackSize() == 1 && this.info1 != null) {
                imp2.setProperty("Info", (Object)this.info1);
            }
            imp2.show();
        }
        IJ.showProgress((double)1.0);
        System.gc();
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        String name = imp.getTitle();
        if (name.length() > 4 && name.substring(name.length() - 4, name.length()).equalsIgnoreCase(".tif")) {
            name = name.substring(0, name.length() - 4);
        }
        for (int i = name.length() - 1; i > 1 && name.charAt(i) >= '0' && name.charAt(i) <= '9'; --i) {
            name = name.substring(0, i);
        }
        HypervolumeOpenerDialog gd = new HypervolumeOpenerDialog("Sequence Options", imp, list);
        gd.addNumericField("Number of Images: ", fileCount, 0);
        gd.addNumericField("Starting Image: ", 1.0, 0);
        gd.addNumericField("Increment: ", 1.0, 0);
        gd.addStringField("File Name Contains: ", name);
        gd.addNumericField("Scale Images", scale, 0, 4, "%");
        gd.addCheckbox("Convert to 8-bit Grayscale", grayscale);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        if ((scale = gd.getNextNumber()) < 5.0) {
            scale = 5.0;
        }
        if (scale > 100.0) {
            scale = 100.0;
        }
        this.filter = gd.getNextString();
        grayscale = gd.getNextBoolean();
        return true;
    }

    static {
        scale = 100.0;
    }
}

