/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.runtime;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.Logical;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class CompiledRuntime {
    public static boolean evaluateCondition(SEXP s) {
        if (s.length() == 0) {
            throw new EvalException("argument is of length zero", new Object[0]);
        }
        Logical logical2 = s.asLogical();
        if (logical2 == Logical.NA) {
            throw new EvalException("missing value where TRUE/FALSE needed", new Object[0]);
        }
        return logical2 == Logical.TRUE;
    }

    public static String[] spliceArgNames(String[] staticArgName, PairList elipses, int insertPos) {
        int i;
        String[] spliced = new String[staticArgName.length + elipses.length() - 1];
        for (i = 0; i < insertPos; ++i) {
            spliced[i] = staticArgName[i];
        }
        int j = insertPos;
        for (PairList.Node node : elipses.nodes()) {
            if (!node.hasTag()) continue;
            spliced[j++] = node.getTag().getPrintName();
        }
        for (i = insertPos + 1; i < staticArgName.length; ++i) {
            spliced[j++] = staticArgName[i];
        }
        return spliced;
    }

    public static SEXP[] spliceArgValues(Context context, SEXP[] staticArgValues, PairList elipses, int insertPos) {
        int i;
        SEXP[] spliced = new SEXP[staticArgValues.length + elipses.length() - 1];
        for (i = 0; i < insertPos; ++i) {
            spliced[i] = staticArgValues[i];
        }
        int j = insertPos;
        for (PairList.Node node : elipses.nodes()) {
            spliced[j++] = node.getValue().force(context);
        }
        for (i = insertPos + 1; i < staticArgValues.length; ++i) {
            spliced[j++] = staticArgValues[i];
        }
        return spliced;
    }
}

