/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.AbstractRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.GeomMaths;
import net.imglib2.roi.geom.real.RealPointCollection;
import net.imglib2.roi.geom.real.WritableRealPointCollection;
import net.imglib2.util.Intervals;

public class DefaultWritableRealPointCollection<L extends RealLocalizable>
extends AbstractRealInterval
implements WritableRealPointCollection<L> {
    private final Map<TDoubleArrayList, L> points;

    public DefaultWritableRealPointCollection(Map<TDoubleArrayList, L> points) {
        super(GeomMaths.getBoundsReal(points.values()));
        this.points = points;
    }

    public DefaultWritableRealPointCollection(Collection<L> points) {
        this(DefaultWritableRealPointCollection.createHashMap(points));
    }

    @Override
    public boolean test(RealLocalizable l) {
        if (Intervals.contains((RealInterval)this, (RealLocalizable)l)) {
            for (RealLocalizable pt : this.points.values()) {
                if (!(this.squareDistance(pt, l) <= 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterable<L> points() {
        return this.points.values();
    }

    @Override
    public long size() {
        return this.points.size();
    }

    @Override
    public void addPoint(L point) {
        if (point.numDimensions() != this.n) {
            throw new IllegalArgumentException("Point must have " + this.n + " dimensions");
        }
        double[] l = new double[point.numDimensions()];
        point.localize(l);
        this.points.put(new TDoubleArrayList(l), point);
        for (int d = 0; d < this.numDimensions(); ++d) {
            if (l[d] > this.max[d]) {
                this.max[d] = l[d];
            }
            if (!(l[d] < this.min[d])) continue;
            this.min[d] = l[d];
        }
    }

    @Override
    public void removePoint(L point) {
        double[] l = new double[point.numDimensions()];
        point.localize(l);
        this.points.remove(new TDoubleArrayList(l));
        this.updateMinMax();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RealPointCollection && RealPointCollection.equals(this, (RealPointCollection)obj);
    }

    public int hashCode() {
        return RealPointCollection.hashCode(this);
    }

    private double squareDistance(L ptOne, RealLocalizable ptTwo) {
        double distance = 0.0;
        for (int i = 0; i < this.n; ++i) {
            distance += (ptOne.getDoublePosition(i) - ptTwo.getDoublePosition(i)) * (ptOne.getDoublePosition(i) - ptTwo.getDoublePosition(i));
        }
        return distance;
    }

    private static <L extends RealLocalizable> HashMap<TDoubleArrayList, L> createHashMap(Collection<L> points) {
        HashMap<TDoubleArrayList, RealLocalizable> map = new HashMap<TDoubleArrayList, RealLocalizable>();
        for (RealLocalizable p : points) {
            double[] l = new double[p.numDimensions()];
            p.localize(l);
            map.put(new TDoubleArrayList(l), p);
        }
        return map;
    }

    private void updateMinMax() {
        RealInterval interval = GeomMaths.getBoundsReal(this.points.values());
        interval.realMin(this.min);
        interval.realMax(this.max);
    }
}

