/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.RealLocalizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.Masks;
import net.imglib2.roi.RealMaskRealInterval;

public interface RealPointCollection<L extends RealLocalizable>
extends RealMaskRealInterval {
    public Iterable<L> points();

    public long size();

    @Override
    default public Class<?> maskType() {
        return RealPointCollection.class;
    }

    @Override
    default public BoundaryType boundaryType() {
        return BoundaryType.CLOSED;
    }

    @Override
    public boolean equals(Object var1);

    public static int hashCode(RealPointCollection<?> points) {
        int result = 71;
        for (RealLocalizable l : points.points()) {
            for (int d = 0; d < l.numDimensions(); ++d) {
                result = (int)((double)result + 3.0 * l.getDoublePosition(d));
            }
        }
        return result;
    }

    public static boolean equals(RealPointCollection<?> points1, RealPointCollection<?> points2) {
        if (points1 == null && points2 == null) {
            return true;
        }
        if (points1 == null || points2 == null || !Masks.sameTypesAndDimensions(points1, points2) || points1.size() != points2.size()) {
            return false;
        }
        for (RealLocalizable p : points1.points()) {
            if (points2.test(p)) continue;
            return false;
        }
        return true;
    }
}

