/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.mask.integer;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.roi.Mask;
import net.imglib2.roi.mask.integer.MaskPredicateRandomAccess;
import net.imglib2.type.BooleanType;

public class MaskAsRandomAccessible<B extends BooleanType<B>>
extends AbstractEuclideanSpace
implements RandomAccessible<B> {
    private final Mask mask;
    private final B type;

    public MaskAsRandomAccessible(Mask mask, B type) {
        super(mask.numDimensions());
        this.mask = mask;
        this.type = type;
    }

    public Mask getSource() {
        return this.mask;
    }

    public RandomAccess<B> randomAccess() {
        return new MaskPredicateRandomAccess<B>(this.mask, this.type);
    }

    public RandomAccess<B> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public B getType() {
        return this.type;
    }
}

