/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.layout;

import java.util.List;

public final class Alignment {
    public static final Alignment None = new Alignment();
    public static final Alignment Center = new Alignment(Bit.Center);
    public static final Alignment Fill = new Alignment(Bit.Fill.value);
    public static final Alignment FillCenter = new Alignment(Bit.Fill.value | Bit.Center.value);
    public final int mask;

    public static int getBits(List<Bit> list) {
        int n = 0;
        for (Bit bit : list) {
            n |= bit.value;
        }
        return n;
    }

    public Alignment(List<Bit> list) {
        this.mask = Alignment.getBits(list);
    }

    public Alignment(Bit bit) {
        this.mask = bit.value;
    }

    public Alignment(int n) {
        this.mask = n;
    }

    public Alignment() {
        this.mask = 0;
    }

    public boolean isSet(Bit bit) {
        return bit.value == (this.mask & bit.value);
    }

    public boolean isSet(List<Bit> list) {
        int n = Alignment.getBits(list);
        return n == (this.mask & n);
    }

    public boolean isSet(int n) {
        return n == (this.mask & n);
    }

    public String toString() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Bit bit : Bit.values()) {
            if (!this.isSet(bit)) continue;
            if (0 < n) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(bit.name());
            ++n;
        }
        if (0 == n) {
            stringBuilder.append("None");
        } else if (1 < n) {
            stringBuilder.insert(0, "[");
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof Alignment && this.mask == ((Alignment)object).mask;
    }

    public static enum Bit {
        Left(1),
        Right(2),
        Bottom(4),
        Top(256),
        Center(512),
        Fill(32768);

        public final int value;

        private Bit(int n2) {
            this.value = n2;
        }
    }
}

