/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class InputActionBindings {
    private final InputMap theInputMap;
    private final ActionMap theActionMap;
    private InputMap parentInputMap;
    private ActionMap parentActionMap;
    private final List<Actions> actions;
    private final List<Keys> inputs;

    public InputActionBindings() {
        this(new InputMap());
    }

    public InputActionBindings(InputMap leafInputMap) {
        this.theInputMap = leafInputMap;
        this.theActionMap = new ActionMap();
        this.actions = new ArrayList<Actions>();
        this.inputs = new ArrayList<Keys>();
    }

    public void addActionMap(String id, ActionMap actionMap) {
        InputActionBindings.removeId(this.actions, id);
        if (actionMap != null) {
            this.actions.add(new Actions(id, actionMap));
        }
        this.updateTheActionMap();
    }

    public void addActionMap(int index, String id, ActionMap actionMap) {
        InputActionBindings.removeId(this.actions, id);
        if (actionMap != null) {
            int i = Math.max(0, Math.min(this.actions.size(), index));
            this.actions.add(i, new Actions(id, actionMap));
        }
        this.updateTheActionMap();
    }

    public void removeActionMap(String id) {
        if (InputActionBindings.removeId(this.actions, id)) {
            this.updateTheActionMap();
        }
    }

    public void setParentActionMap(ActionMap parent) {
        this.parentActionMap = parent;
        this.updateTheActionMap();
    }

    public void addInputMap(String id, InputMap inputMap, String ... idsToBlock) {
        this.addInputMap(id, inputMap, Arrays.asList(idsToBlock));
    }

    public void addInputMap(String id, InputMap inputMap, Collection<String> idsToBlock) {
        InputActionBindings.removeId(this.inputs, id);
        if (inputMap != null) {
            this.inputs.add(new Keys(id, inputMap, idsToBlock));
        }
        this.updateTheInputMap();
    }

    public void addInputMap(int index, String id, InputMap inputMap, String ... idsToBlock) {
        this.addInputMap(index, id, inputMap, Arrays.asList(idsToBlock));
    }

    public void addInputMap(int index, String id, InputMap inputMap, Collection<String> idsToBlock) {
        InputActionBindings.removeId(this.inputs, id);
        if (inputMap != null) {
            int i = Math.max(0, Math.min(this.inputs.size(), index));
            this.inputs.add(i, new Keys(id, inputMap, idsToBlock));
        }
        this.updateTheInputMap();
    }

    public void removeInputMap(String id) {
        if (InputActionBindings.removeId(this.inputs, id)) {
            this.updateTheInputMap();
        }
    }

    public void setParentInputMap(InputMap parent) {
        this.parentInputMap = parent;
        this.updateTheInputMap();
    }

    public InputMap getConcatenatedInputMap() {
        return this.theInputMap;
    }

    public ActionMap getConcatenatedActionMap() {
        return this.theActionMap;
    }

    public static InputActionBindings installNewBindings(JComponent component, int condition, boolean replaceExistingMaps) {
        InputActionBindings keybindings = new InputActionBindings();
        if (!replaceExistingMaps) {
            ActionMap existingActionMap = component.getActionMap();
            InputMap existingInputMap = component.getInputMap(condition);
            keybindings.setParentActionMap(existingActionMap.getParent());
            keybindings.setParentInputMap(existingInputMap.getParent());
        }
        SwingUtilities.replaceUIActionMap(component, keybindings.getConcatenatedActionMap());
        SwingUtilities.replaceUIInputMap(component, condition, keybindings.getConcatenatedInputMap());
        return keybindings;
    }

    private static boolean removeId(List<? extends WithId> list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getId().equals(id)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    private void updateTheActionMap() {
        ListIterator<Actions> iter = this.actions.listIterator(this.actions.size());
        ActionMap root = this.theActionMap;
        while (iter.hasPrevious()) {
            ActionMap map = iter.previous().getActionMap();
            if (map == null) continue;
            root.setParent(map);
            root = map;
        }
        root.setParent(this.parentActionMap);
    }

    private void updateTheInputMap() {
        ListIterator<Keys> iter = this.inputs.listIterator(this.inputs.size());
        InputMap root = this.theInputMap;
        HashSet<String> blocked = new HashSet<String>();
        while (iter.hasPrevious()) {
            Keys keys = iter.previous();
            if (blocked.contains(keys.getId())) continue;
            InputMap map = keys.getInputMap();
            if (map != null) {
                root.setParent(map);
                root = map;
            }
            blocked.addAll(keys.getKeysIdsToBlock());
            if (!blocked.contains("all")) continue;
            root.setParent(null);
            return;
        }
        root.setParent(this.parentInputMap);
    }

    private static class Keys
    implements WithId {
        private final String id;
        private final InputMap inputMap;
        private final HashSet<String> idsToBlock;

        public Keys(String id, InputMap inputMap, Collection<String> idsToBlock) {
            this.id = id;
            this.inputMap = inputMap;
            this.idsToBlock = new HashSet<String>(idsToBlock);
        }

        @Override
        public String getId() {
            return this.id;
        }

        public InputMap getInputMap() {
            return this.inputMap;
        }

        public Set<String> getKeysIdsToBlock() {
            return this.idsToBlock;
        }
    }

    private static class Actions
    implements WithId {
        private final String id;
        private final ActionMap actionMap;

        public Actions(String id, ActionMap actionMap) {
            this.id = id;
            this.actionMap = actionMap;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public ActionMap getActionMap() {
            return this.actionMap;
        }
    }

    private static interface WithId {
        public String getId();
    }
}

