/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import java.util.ArrayList;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.RkRec;
import loci.poi.hssf.util.RKUtil;

public class MulRKRecord
extends Record {
    public static final short sid = 189;
    private int field_1_row;
    private short field_2_first_col;
    private ArrayList field_3_rks;
    private short field_4_last_col;

    public MulRKRecord() {
    }

    public MulRKRecord(RecordInputStream in) {
        super(in);
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int coffset) {
        return ((RkRec)this.field_3_rks.get((int)coffset)).xf;
    }

    public double getRKNumberAt(int coffset) {
        return RKUtil.decodeNumber(((RkRec)this.field_3_rks.get((int)coffset)).rk);
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_first_col = in.readShort();
        this.field_3_rks = this.parseRKs(in);
        this.field_4_last_col = in.readShort();
    }

    private ArrayList parseRKs(RecordInputStream in) {
        ArrayList<RkRec> retval = new ArrayList<RkRec>();
        while (in.remaining() - 2 > 0) {
            RkRec rec = new RkRec();
            rec.xf = in.readShort();
            rec.rk = in.readInt();
            retval.add(rec);
        }
        return retval;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MULRK]\n");
        buffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        for (int k = 0; k < this.getNumColumns(); ++k) {
            buffer.append("xf").append(k).append("        = ").append(Integer.toHexString(this.getXFAt(k))).append("\n");
            buffer.append("rk").append(k).append("        = ").append(this.getRKNumberAt(k)).append("\n");
        }
        buffer.append("[/MULRK]\n");
        return buffer.toString();
    }

    @Override
    protected void validateSid(short id) {
        if (id != 189) {
            throw new RecordFormatException("Not a MulRKRecord!");
        }
    }

    @Override
    public short getSid() {
        return 189;
    }

    @Override
    public int serialize(int offset, byte[] data) {
        throw new RecordFormatException("Sorry, you can't serialize a MulRK in this release");
    }
}

