/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.poi.poifs.property.DirectoryProperty;
import loci.poi.poifs.property.DocumentProperty;
import loci.poi.poifs.property.Property;
import loci.poi.poifs.property.RootProperty;
import loci.poi.poifs.storage.ListManagedBlock;

class PropertyFactory {
    private PropertyFactory() {
    }

    static List convertToProperties(ListManagedBlock[] blocks) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int j = 0; j < blocks.length; ++j) {
            byte[] data = blocks[j].getData();
            int property_count = data.length / 128;
            int offset = 0;
            for (int k = 0; k < property_count; ++k) {
                switch (data[offset + 66]) {
                    case 1: {
                        properties.add(new DirectoryProperty(properties.size(), data, offset));
                        break;
                    }
                    case 2: {
                        properties.add(new DocumentProperty(properties.size(), data, offset));
                        break;
                    }
                    case 5: {
                        properties.add(new RootProperty(properties.size(), data, offset));
                        break;
                    }
                    default: {
                        properties.add(null);
                    }
                }
                offset += 128;
            }
        }
        return properties;
    }
}

