/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.fits;

import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.util.ConstantUtils;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.fits.AbstractCorrelationFit;

public class GlobalCorrelationFitAverage
extends AbstractCorrelationFit {
    private double[] summedMeasurements;
    private double[] weightSum;

    @Override
    protected void add(int z, int dz, double value, double weight) {
        int n = dz;
        this.summedMeasurements[n] = this.summedMeasurements[n] + value * weight;
        int n2 = dz;
        this.weightSum[n2] = this.weightSum[n2] + weight;
    }

    @Override
    protected void init(int size) {
        this.summedMeasurements = new double[size + 1];
        this.weightSum = new double[size + 1];
    }

    @Override
    protected RandomAccessibleInterval<double[]> estimate(int size) {
        double[] estimate = (double[])this.summedMeasurements.clone();
        estimate[0] = -1.0;
        for (int z = 1; z < estimate.length; ++z) {
            int n = z;
            estimate[n] = estimate[n] / -this.weightSum[z];
        }
        FinalInterval fi = new FinalInterval(new long[]{size});
        return Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)ConstantUtils.constantRealRandomAccessible((Object)estimate, (int)1)), (Interval)fi);
    }
}

