/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.realtransform.InvertibleRealTransform;

public abstract class AbstractLUTRealTransform
implements InvertibleRealTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;
    protected final int lutMaxIndex;
    protected final double[] lut;

    public AbstractLUTRealTransform(double[] lut, int numSourceDimensions, int numTargetDimensions) {
        this.lut = lut;
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
        this.lutMaxIndex = lut.length - 1;
    }

    protected double apply(double x) {
        int xFloor = (int)x;
        double dx = x - (double)xFloor;
        return (this.lut[xFloor + 1] - this.lut[xFloor]) * dx + this.lut[xFloor];
    }

    protected double applyChecked(double x) {
        if (x < 0.0) {
            return -1.7976931348623157E308;
        }
        if (x > (double)this.lutMaxIndex) {
            return Double.MAX_VALUE;
        }
        if (x == (double)this.lutMaxIndex) {
            return this.lut[this.lutMaxIndex];
        }
        return this.apply(x);
    }

    protected int findFloorIndex(double y) {
        int min = 0;
        int max = this.lutMaxIndex;
        int i = max >> 1;
        do {
            if (this.lut[i] > y) {
                max = i;
                continue;
            }
            min = i;
        } while ((i = (max - min >> 1) + min) != min);
        return i;
    }

    protected double applyInverse(double y) {
        int i = this.findFloorIndex(y);
        double x1 = this.lut[i];
        double x2 = this.lut[i + 1];
        return (y - x1) / (x2 - x1) + (double)i;
    }

    protected double applyInverseChecked(double y) {
        if (y < this.lut[0]) {
            return -1.7976931348623157E308;
        }
        if (y > this.lut[this.lutMaxIndex]) {
            return Double.MAX_VALUE;
        }
        return this.applyInverse(y);
    }

    public double minTransformedCoordinate() {
        return this.lut[0];
    }

    public double maxTransformedCoordinate() {
        return this.lut[this.lutMaxIndex];
    }

    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }
}

