/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Arrays;
import sun.security.krb5.Checksum;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcReq;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbTgsReq
extends KrbKdcReq {
    private PrincipalName princName;
    private PrincipalName clientAlias;
    private PrincipalName servName;
    private PrincipalName serverAlias;
    private TGSReq tgsReqMessg;
    private KerberosTime ctime;
    private Credentials additionalCreds = null;
    private boolean useSubkey = false;
    EncryptionKey tgsReqKey;
    private static final boolean DEBUG = Krb5.DEBUG;

    public KrbTgsReq(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, PrincipalName principalName2, PrincipalName principalName3, PrincipalName principalName4, Credentials credentials2, PAData[] pADataArray) throws KrbException, IOException {
        this(kDCOptions, credentials, principalName, principalName2, principalName3, principalName4, null, null, null, null, null, null, credentials2, null, pADataArray);
    }

    KrbTgsReq(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Credentials credentials2, EncryptionKey encryptionKey) throws KrbException, IOException {
        this(kDCOptions, credentials, credentials.getClient(), credentials.getClientAlias(), principalName, principalName2, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, authorizationData, credentials2, encryptionKey, null);
    }

    private KrbTgsReq(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, PrincipalName principalName2, PrincipalName principalName3, PrincipalName principalName4, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Credentials credentials2, EncryptionKey encryptionKey, PAData[] pADataArray) throws KrbException, IOException {
        this.princName = principalName;
        this.clientAlias = principalName2;
        this.servName = principalName3;
        this.serverAlias = principalName4;
        this.ctime = KerberosTime.now();
        if (kDCOptions.get(1) && !credentials.flags.get(1)) {
            kDCOptions.set(1, false);
        }
        if (kDCOptions.get(2) && !credentials.flags.get(1)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(3) && !credentials.flags.get(3)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(4) && !credentials.flags.get(3)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(5) && !credentials.flags.get(5)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(8) && !credentials.flags.get(8)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(6)) {
            if (!credentials.flags.get(6)) {
                throw new KrbException(101);
            }
        } else if (kerberosTime != null) {
            kerberosTime = null;
        }
        if (kDCOptions.get(8)) {
            if (!credentials.flags.get(8)) {
                throw new KrbException(101);
            }
        } else if (kerberosTime3 != null) {
            kerberosTime3 = null;
        }
        if (kDCOptions.get(28) || kDCOptions.get(14)) {
            if (credentials2 == null) {
                throw new KrbException(101);
            }
            this.additionalCreds = credentials2;
        } else if (credentials2 != null) {
            credentials2 = null;
        }
        this.tgsReqMessg = this.createRequest(kDCOptions, credentials.ticket, credentials.key, this.ctime, this.princName, this.servName, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, authorizationData, credentials2, encryptionKey, pADataArray);
        this.obuf = this.tgsReqMessg.asn1Encode();
        if (credentials.flags.get(2)) {
            kDCOptions.set(2, true);
        }
    }

    public Credentials sendAndGetCreds() throws IOException, KrbException {
        String string = this.servName != null ? this.servName.getRealmString() : null;
        KdcComm kdcComm = new KdcComm(string);
        return new KrbTgsRep(kdcComm.send(this), this).getCreds();
    }

    KerberosTime getCtime() {
        return this.ctime;
    }

    private TGSReq createRequest(KDCOptions kDCOptions, Ticket ticket, EncryptionKey encryptionKey, KerberosTime kerberosTime, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Credentials credentials, EncryptionKey encryptionKey2, PAData[] pADataArray) throws IOException, KrbException, UnknownHostException {
        PAData[] pADataArray2;
        Ticket[] ticketArray;
        byte[] byArray;
        Object object;
        KerberosTime kerberosTime5 = null;
        kerberosTime5 = kerberosTime3 == null ? ((object = (Object)Config.getInstance().get("libdefaults", "ticket_lifetime")) != null ? new KerberosTime(Instant.now().plusSeconds(Config.duration((String)object))) : new KerberosTime(0L)) : kerberosTime3;
        this.tgsReqKey = encryptionKey;
        object = null;
        object = nArray == null ? EType.getDefaults("default_tgs_enctypes") : nArray;
        EncryptionKey encryptionKey3 = null;
        EncryptedData encryptedData = null;
        if (authorizationData != null) {
            byArray = authorizationData.asn1Encode();
            if (encryptionKey2 != null) {
                encryptionKey3 = encryptionKey2;
                this.tgsReqKey = encryptionKey2;
                this.useSubkey = true;
                encryptedData = new EncryptedData(encryptionKey3, byArray, 5);
            } else {
                encryptedData = new EncryptedData(encryptionKey, byArray, 4);
            }
        }
        if (credentials == null) {
            ticketArray = null;
        } else {
            Ticket[] ticketArray2 = new Ticket[1];
            ticketArray = ticketArray2;
            ticketArray2[0] = credentials.getTicket();
        }
        byArray = ticketArray;
        KDCReqBody kDCReqBody = new KDCReqBody(kDCOptions, principalName, principalName2, kerberosTime2, kerberosTime5, kerberosTime4, Nonce.value(), (int[])object, hostAddresses, encryptedData, (Ticket[])byArray);
        byte[] byArray2 = kDCReqBody.asn1Encode(12);
        Checksum checksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, byArray2, encryptionKey, 6);
        byte[] byArray3 = new KrbApReq(new APOptions(), ticket, encryptionKey, principalName, checksum, kerberosTime, encryptionKey3, null, null).getMessage();
        PAData pAData = new PAData(1, byArray3);
        if (pADataArray != null) {
            pADataArray2 = Arrays.copyOf(pADataArray, pADataArray.length + 1);
            pADataArray2[pADataArray.length] = pAData;
        } else {
            pADataArray2 = new PAData[]{pAData};
        }
        return new TGSReq(pADataArray2, kDCReqBody);
    }

    TGSReq getMessage() {
        return this.tgsReqMessg;
    }

    Credentials getAdditionalCreds() {
        return this.additionalCreds;
    }

    PrincipalName getClientAlias() {
        return this.clientAlias;
    }

    PrincipalName getServerAlias() {
        return this.serverAlias;
    }

    private static void debug(String string) {
    }

    boolean usedSubkey() {
        return this.useSubkey;
    }
}

