/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.awt.Image;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.loaders.IncorrectFormatException;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.LWOBFileReader;
import org.jogamp.java3d.loaders.lw3d.LwoTexture;
import org.jogamp.java3d.loaders.lw3d.ParserObject;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector3f;

class LwoSurface
extends ParserObject {
    LWOBFileReader theReader;
    int red = 255;
    int green = 255;
    int blue = 255;
    float diffuse = 0.0f;
    float specular = 0.0f;
    float transparency = 0.0f;
    float luminosity = 0.0f;
    float creaseAngle = 0.0f;
    int gloss = 128;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    float shininess;
    Image theImage = null;
    Vector3f textureCenter = null;
    Vector3f textureSize = null;
    int textureAxis;
    String surfName;
    Vector textureList = new Vector();

    LwoSurface(LWOBFileReader reader, int length, int debugVals) throws FileNotFoundException {
        super(debugVals);
        this.debugOutputLn(1, "LwoSurface()");
        this.theReader = reader;
        this.getSurf(length);
        this.setJ3dColors();
    }

    void setJ3dColors() {
        this.color = new Color3f((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f);
        this.diffuseColor = new Color3f(this.diffuse * this.color.x, this.diffuse * this.color.y, this.diffuse * this.color.z);
        this.specularColor = new Color3f(this.specular * this.color.x, this.specular * this.color.y, this.specular * this.color.z);
        this.emissiveColor = new Color3f(this.luminosity * this.color.x, this.luminosity * this.color.y, this.luminosity * this.color.z);
        this.shininess = (float)(128.0 * ((double)this.gloss / 1024.0));
    }

    Color3f getColor() {
        return this.color;
    }

    Color3f getDiffuseColor() {
        return this.diffuseColor;
    }

    Color3f getSpecularColor() {
        return this.specularColor;
    }

    Color3f getEmissiveColor() {
        return this.emissiveColor;
    }

    float getShininess() {
        return this.shininess;
    }

    float getCreaseAngle() {
        return this.creaseAngle;
    }

    LwoTexture getTexture() {
        this.debugOutputLn(1, "getTexture()");
        try {
            if (this.textureList.isEmpty()) {
                return null;
            }
            return (LwoTexture)this.textureList.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.debugOutputLn(16, "getTexture(), exception returning first element: " + e);
            return null;
        }
    }

    String getSurfName() {
        return this.surfName;
    }

    float getTransparency() {
        return this.transparency;
    }

    void getSurf(int length) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.debugOutputLn(1, "getSurf()");
        boolean gotLuminosityFloat = false;
        boolean gotTransparencyFloat = false;
        boolean gotDiffuseFloat = false;
        boolean gotSpecularFloat = false;
        int surfStopMarker = this.theReader.getMarker() + length;
        this.surfName = this.theReader.getString();
        String tokenString = this.theReader.getToken();
        while (tokenString != null && this.theReader.getMarker() < surfStopMarker) {
            this.debugOutputLn(2, "  tokenString = " + tokenString);
            this.debugOutputLn(2, "  marker, stop = " + this.theReader.getMarker() + ", " + surfStopMarker);
            String textureToken = null;
            int fieldLength = this.theReader.getShortInt();
            this.debugOutputLn(2, "  fl = " + fieldLength);
            if (tokenString.equals("COLR")) {
                this.debugOutputLn(8, "  COLR");
                try {
                    this.red = this.theReader.read();
                    this.green = this.theReader.read();
                    this.blue = this.theReader.read();
                    this.theReader.read();
                }
                catch (IOException e) {
                    throw new ParsingErrorException(e.getMessage());
                }
                if (fieldLength != 4) {
                    throw new IncorrectFormatException(J3dUtilsI18N.getString("LwoSurface0"));
                }
            } else if (tokenString.equals("FLAG")) {
                this.debugOutputLn(8, "  FLAG");
                this.theReader.skipLength(fieldLength);
            } else if (tokenString.equals("VLUM")) {
                this.debugOutputLn(8, "  VLUM");
                this.luminosity = this.theReader.getFloat();
                gotLuminosityFloat = true;
            } else if (tokenString.equals("LUMI")) {
                this.debugOutputLn(8, "  LUMI");
                if (gotLuminosityFloat) {
                    this.theReader.skipLength(fieldLength);
                } else {
                    this.luminosity = (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (tokenString.equals("VDIF")) {
                this.debugOutputLn(8, "  VDIF");
                if (fieldLength != 4) {
                    throw new IncorrectFormatException("VDIF problem");
                }
                this.diffuse = this.theReader.getFloat();
                gotDiffuseFloat = true;
                this.debugOutputLn(2, "diff = " + this.diffuse);
            } else if (tokenString.equals("DIFF")) {
                this.debugOutputLn(8, "  DIFF");
                if (gotDiffuseFloat) {
                    this.theReader.skipLength(fieldLength);
                } else {
                    this.diffuse = (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (tokenString.equals("VTRN")) {
                this.debugOutputLn(8, "  VTRN");
                this.transparency = this.theReader.getFloat();
                gotTransparencyFloat = true;
            } else if (tokenString.equals("TRAN")) {
                this.debugOutputLn(8, "  TRAN");
                if (gotTransparencyFloat) {
                    this.theReader.skipLength(fieldLength);
                } else {
                    this.transparency = (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (tokenString.equals("VSPC")) {
                this.debugOutputLn(8, "  VSPC");
                this.specular = this.theReader.getFloat();
                gotSpecularFloat = true;
                this.debugOutputLn(2, "spec = " + this.specular);
            } else if (tokenString.equals("SPEC")) {
                this.debugOutputLn(8, "  SPEC");
                if (gotSpecularFloat) {
                    this.theReader.skipLength(fieldLength);
                } else {
                    this.specular = fieldLength == 4 ? (float)this.theReader.getInt() / 255.0f : (float)this.theReader.getShortInt() / 255.0f;
                }
            } else if (tokenString.equals("GLOS")) {
                this.debugOutputLn(8, "  GLOS");
                this.gloss = fieldLength == 4 ? this.theReader.getInt() : this.theReader.getShortInt();
            } else if (tokenString.equals("SMAN")) {
                this.debugOutputLn(8, "  SMAN");
                this.creaseAngle = this.theReader.getFloat();
            } else if (tokenString.endsWith("TEX")) {
                LwoTexture texture = new LwoTexture(this.theReader, surfStopMarker - this.theReader.getMarker(), tokenString, this.debugPrinter.getValidOutput());
                textureToken = texture.getNextToken();
                if (texture.isHandled()) {
                    this.textureList.addElement(texture);
                }
                this.debugOutputLn(64, "val = " + tokenString);
            } else {
                this.debugOutputLn(64, "unrecognized token: " + tokenString);
                this.theReader.skipLength(fieldLength);
            }
            if (this.theReader.getMarker() >= surfStopMarker) continue;
            if (textureToken == null) {
                tokenString = this.theReader.getToken();
                continue;
            }
            tokenString = textureToken;
        }
    }
}

