/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.shader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.utils.shader.SimpleShaderAppearance;

public class Cube
extends Shape3D {
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final float[] colors = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    public Cube() {
        TriangleArray cube = new TriangleArray(36, 2181);
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(verts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double scale) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        for (int i = 0; i < verts.length; ++i) {
            scaledVerts[i] = verts[i] * (float)scale;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double scale, float r, float g, float b) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        for (int i = 0; i < verts.length; ++i) {
            scaledVerts[i] = verts[i] * (float)scale;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        float[] colorsSet = new float[108];
        for (int i = 0; i < 36; ++i) {
            colorsSet[i * 3 + 0] = r;
            colorsSet[i * 3 + 1] = g;
            colorsSet[i * 3 + 2] = b;
        }
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colorsSet)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double xScale, double yScale, double zScale) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        for (int i = 0; i < verts.length; i += 3) {
            scaledVerts[i + 0] = verts[i + 0] * (float)xScale;
            scaledVerts[i + 1] = verts[i + 1] * (float)yScale;
            scaledVerts[i + 2] = verts[i + 2] * (float)zScale;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double xScale, double yScale, double zScale, float r, float g, float b) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        for (int i = 0; i < verts.length; i += 3) {
            scaledVerts[i + 0] = verts[i + 0] * (float)xScale;
            scaledVerts[i + 1] = verts[i + 1] * (float)yScale;
            scaledVerts[i + 2] = verts[i + 2] * (float)zScale;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        float[] colorsSet = new float[108];
        for (int i = 0; i < 36; ++i) {
            colorsSet[i * 3 + 0] = r;
            colorsSet[i * 3 + 1] = g;
            colorsSet[i * 3 + 2] = b;
        }
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colorsSet)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(float xMin, float yMin, float zMin, float xMax, float yMax, float zMax) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[]{xMax, yMin, zMax, xMax, yMax, zMax, xMin, yMax, zMax, xMax, yMin, zMax, xMin, yMax, zMax, xMin, yMin, zMax, xMin, yMin, zMin, xMin, yMax, zMin, xMax, yMax, zMin, xMin, yMin, zMin, xMax, yMax, zMin, xMax, yMin, zMin, xMax, yMin, zMin, xMax, yMax, zMin, xMax, yMax, zMax, xMax, yMin, zMin, xMax, yMax, zMax, xMax, yMin, zMax, xMin, yMin, zMax, xMin, yMax, zMax, xMin, yMax, zMin, xMin, yMin, zMax, xMin, yMax, zMin, xMin, yMin, zMin, xMax, yMax, zMax, xMax, yMax, zMin, xMin, yMax, zMin, xMax, yMax, zMax, xMin, yMax, zMin, xMin, yMax, zMax, xMin, yMin, zMax, xMin, yMin, zMin, xMax, yMin, zMin, xMin, yMin, zMax, xMax, yMin, zMin, xMax, yMin, zMax};
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public static FloatBuffer makeFloatBuffer(float[] arr) {
        ByteBuffer bb = ByteBuffer.allocateDirect(arr.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(arr);
        fb.position(0);
        return fb;
    }
}

