/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class DMatrixEvd {
    private int _n;
    private double[][] _v;
    private double[] _d;
    private double[] _e;
    private double[][] _h;
    private double _cdivr;
    private double _cdivi;

    public DMatrixEvd(DMatrix a) {
        int n;
        Check.argument(a.isSquare(), "matrix a is square");
        double[][] aa = a.getArray();
        this._n = n = a.getN();
        this._v = new double[n][n];
        this._d = new double[n];
        this._e = new double[n];
        if (a.isSymmetric()) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this._v[i][j] = aa[i][j];
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this._h = new double[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this._h[i][j] = aa[i][j];
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    public DMatrix getV() {
        return new DMatrix(this._n, this._n, this._v);
    }

    public DMatrix getD() {
        DMatrix d = new DMatrix(this._n, this._n);
        double[][] da = d.getArray();
        for (int i = 0; i < this._n; ++i) {
            for (int j = 0; j < this._n; ++j) {
                da[i][j] = 0.0;
            }
            da[i][i] = this._d[i];
            if (this._e[i] > 0.0) {
                da[i][i + 1] = this._e[i];
                continue;
            }
            if (!(this._e[i] < 0.0)) continue;
            da[i][i - 1] = this._e[i];
        }
        return d;
    }

    public double[] getRealEigenvalues() {
        return ArrayMath.copy(this._d);
    }

    public double[] getImagEigenvalues() {
        return ArrayMath.copy(this._e);
    }

    private void tred2() {
        int i;
        int j;
        int n = this._n;
        for (j = 0; j < n; ++j) {
            this._d[j] = this._v[n - 1][j];
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += ArrayMath.abs(this._d[k]);
            }
            if (scale == 0.0) {
                this._e[i] = this._d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    this._d[j2] = this._v[i - 1][j2];
                    this._v[i][j2] = 0.0;
                    this._v[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    this._d[n2] = this._d[n2] / scale;
                    h += this._d[k] * this._d[k];
                }
                double f = this._d[i - 1];
                double g = ArrayMath.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this._e[i] = scale * g;
                h -= f * g;
                this._d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    this._e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    this._v[j4][i] = f = this._d[j4];
                    g = this._e[j4] + this._v[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += this._v[k2][j4] * this._d[k2];
                        int n3 = k2;
                        this._e[n3] = this._e[n3] + this._v[k2][j4] * f;
                    }
                    this._e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n4 = j4;
                    this._e[n4] = this._e[n4] / h;
                    f += this._e[j4] * this._d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n5 = j3;
                    this._e[n5] = this._e[n5] - hh * this._d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = this._d[j3];
                    g = this._e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = this._v[k3];
                        int n6 = j3;
                        dArray[n6] = dArray[n6] - (f * this._e[k3] + g * this._d[k3]);
                    }
                    this._d[j3] = this._v[i - 1][j3];
                    this._v[i][j3] = 0.0;
                }
            }
            this._d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            this._v[n - 1][i] = this._v[i][i];
            this._v[i][i] = 1.0;
            double h = this._d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this._d[k] = this._v[k][i + 1] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += this._v[k4][i + 1] * this._v[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = this._v[k4];
                        int n7 = j5;
                        dArray[n7] = dArray[n7] - g * this._d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this._v[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < n; ++j) {
            this._d[j] = this._v[n - 1][j];
            this._v[n - 1][j] = 0.0;
        }
        this._v[n - 1][n - 1] = 1.0;
        this._e[0] = 0.0;
    }

    private void tql2() {
        int n = this._n;
        for (int i = 1; i < n; ++i) {
            this._e[i - 1] = this._e[i];
        }
        this._e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = ArrayMath.pow(2.0, -52.0);
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = ArrayMath.max(tst1, ArrayMath.abs(this._d[l]) + ArrayMath.abs(this._e[l]));
            for (m = l; m < n && !(ArrayMath.abs(this._e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                do {
                    double c;
                    double g = this._d[l];
                    double p = (this._d[l + 1] - g) / (2.0 * this._e[l]);
                    double r = ArrayMath.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this._d[l] = this._e[l] / (p + r);
                    this._d[l + 1] = this._e[l] * (p + r);
                    double dl1 = this._d[l + 1];
                    double h = g - this._d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        this._d[n2] = this._d[n2] - h;
                    }
                    f += h;
                    p = this._d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this._e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this._e[i2];
                        h = c * p;
                        r = ArrayMath.hypot(p, this._e[i2]);
                        this._e[i2 + 1] = s * r;
                        s = this._e[i2] / r;
                        c = p / r;
                        p = c * this._d[i2] - s * g;
                        this._d[i2 + 1] = h + s * (c * g + s * this._d[i2]);
                        for (int k = 0; k < n; ++k) {
                            h = this._v[k][i2 + 1];
                            this._v[k][i2 + 1] = s * this._v[k][i2] + c * h;
                            this._v[k][i2] = c * this._v[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this._e[l] / dl1;
                    this._e[l] = s * p;
                    this._d[l] = c * p;
                } while (ArrayMath.abs(this._e[l]) > eps * tst1);
            }
            int n3 = l;
            this._d[n3] = this._d[n3] + f;
            this._e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = this._d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(this._d[j] < p)) continue;
                k = j;
                p = this._d[j];
            }
            if (k == i) continue;
            this._d[k] = this._d[i];
            this._d[i] = p;
            for (j = 0; j < n; ++j) {
                p = this._v[j][i];
                this._v[j][i] = this._v[j][k];
                this._v[j][k] = p;
            }
        }
    }

    private void orthes() {
        int m;
        int n = this._n;
        int low = 0;
        int high = n - 1;
        double[] ort = new double[n];
        for (m = low + 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += ArrayMath.abs(this._h[i][m - 1]);
            }
            if (scale == 0.0) continue;
            double h = 0.0;
            for (int i = high; i >= m; --i) {
                ort[i] = this._h[i][m - 1] / scale;
                h += ort[i] * ort[i];
            }
            double g = ArrayMath.sqrt(h);
            if (ort[m] > 0.0) {
                g = -g;
            }
            h -= ort[m] * g;
            int n2 = m;
            ort[n2] = ort[n2] - g;
            for (int j = m; j < n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m; --i) {
                    f += ort[i] * this._h[i][j];
                }
                f /= h;
                for (i = m; i <= high; ++i) {
                    double[] dArray = this._h[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - f * ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += ort[j] * this._h[i][j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    double[] dArray = this._h[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] - f * ort[j];
                }
            }
            ort[m] = scale * ort[m];
            this._h[m][m - 1] = scale * g;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this._v[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (m = high - 1; m >= low + 1; --m) {
            if (this._h[m][m - 1] == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                ort[i] = this._h[i][m - 1];
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += ort[i] * this._v[i][j];
                }
                g = g / ort[m] / this._h[m][m - 1];
                for (i = m; i <= high; ++i) {
                    double[] dArray = this._v[i];
                    int n5 = j;
                    dArray[n5] = dArray[n5] + g * ort[i];
                }
            }
        }
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (ArrayMath.abs(yr) > ArrayMath.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this._cdivr = (xr + r * xi) / d;
            this._cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this._cdivr = (r * xr + xi) / d;
            this._cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        double y;
        int i;
        int j;
        double x;
        double w;
        int l;
        int j2;
        int nn = this._n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = ArrayMath.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < low || i2 > high) {
                this._d[i2] = this._h[i2][i2];
                this._e[i2] = 0.0;
            }
            for (j2 = ArrayMath.max(i2 - 1, 0); j2 < nn; ++j2) {
                norm += ArrayMath.abs(this._h[i2][j2]);
            }
        }
        int iter = 0;
        block2: while (n >= low) {
            int m;
            for (l = n; l > low; --l) {
                s = ArrayMath.abs(this._h[l - 1][l - 1]) + ArrayMath.abs(this._h[l][l]);
                if (s == 0.0) {
                    s = norm;
                }
                if (ArrayMath.abs(this._h[l][l - 1]) < eps * s) break;
            }
            if (l == n) {
                this._h[n][n] = this._h[n][n] + exshift;
                this._d[n] = this._h[n][n];
                this._e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this._h[n][n - 1] * this._h[n - 1][n];
                p = (this._h[n - 1][n - 1] - this._h[n][n]) / 2.0;
                q = p * p + w;
                z = ArrayMath.sqrt(ArrayMath.abs(q));
                this._h[n][n] = this._h[n][n] + exshift;
                this._h[n - 1][n - 1] = this._h[n - 1][n - 1] + exshift;
                x = this._h[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this._d[n - 1] = x + z;
                    this._d[n] = this._d[n - 1];
                    if (z != 0.0) {
                        this._d[n] = x - w / z;
                    }
                    this._e[n - 1] = 0.0;
                    this._e[n] = 0.0;
                    x = this._h[n][n - 1];
                    s = ArrayMath.abs(x) + ArrayMath.abs(z);
                    p = x / s;
                    q = z / s;
                    r = ArrayMath.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = this._h[n - 1][j];
                        this._h[n - 1][j] = q * z + p * this._h[n][j];
                        this._h[n][j] = q * this._h[n][j] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = this._h[i][n - 1];
                        this._h[i][n - 1] = q * z + p * this._h[i][n];
                        this._h[i][n] = q * this._h[i][n] - p * z;
                    }
                    for (i = low; i <= high; ++i) {
                        z = this._v[i][n - 1];
                        this._v[i][n - 1] = q * z + p * this._v[i][n];
                        this._v[i][n] = q * this._v[i][n] - p * z;
                    }
                } else {
                    this._d[n - 1] = x + p;
                    this._d[n] = x + p;
                    this._e[n - 1] = z;
                    this._e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this._h[n][n];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this._h[n - 1][n - 1];
                w = this._h[n][n - 1] * this._h[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = low;
                while (i <= n) {
                    double[] dArray = this._h[i];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] - x;
                }
                s = ArrayMath.abs(this._h[n][n - 1]) + ArrayMath.abs(this._h[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = ArrayMath.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    i = low;
                    while (i <= n) {
                        double[] dArray = this._h[i];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this._h[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this._h[m + 1][m] + this._h[m][m + 1];
                q = this._h[m + 1][m + 1] - z - r - s;
                r = this._h[m + 2][m + 1];
                s = ArrayMath.abs(p) + ArrayMath.abs(q) + ArrayMath.abs(r);
                if (m == l || ArrayMath.abs(this._h[m][m - 1]) * (ArrayMath.abs(q /= s) + ArrayMath.abs(r /= s)) < eps * (ArrayMath.abs(p /= s) * (ArrayMath.abs(this._h[m - 1][m - 1]) + ArrayMath.abs(z) + ArrayMath.abs(this._h[m + 1][m + 1])))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                this._h[i3][i3 - 2] = 0.0;
                if (i3 <= m + 2) continue;
                this._h[i3][i3 - 3] = 0.0;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this._h[k][k - 1];
                    q = this._h[k + 1][k - 1];
                    r = notlast ? this._h[k + 2][k - 1] : 0.0;
                    x = ArrayMath.abs(p) + ArrayMath.abs(q) + ArrayMath.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = ArrayMath.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this._h[k][k - 1] = -s * x;
                } else if (l != m) {
                    this._h[k][k - 1] = -this._h[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = this._h[k][j3] + q * this._h[k + 1][j3];
                    if (notlast) {
                        this._h[k + 2][j3] = this._h[k + 2][j3] - (p += r * this._h[k + 2][j3]) * z;
                    }
                    this._h[k][j3] = this._h[k][j3] - p * x;
                    this._h[k + 1][j3] = this._h[k + 1][j3] - p * y;
                }
                for (i4 = 0; i4 <= ArrayMath.min(n, k + 3); ++i4) {
                    p = x * this._h[i4][k] + y * this._h[i4][k + 1];
                    if (notlast) {
                        this._h[i4][k + 2] = this._h[i4][k + 2] - (p += z * this._h[i4][k + 2]) * r;
                    }
                    this._h[i4][k] = this._h[i4][k] - p;
                    this._h[i4][k + 1] = this._h[i4][k + 1] - p * q;
                }
                for (i4 = low; i4 <= high; ++i4) {
                    p = x * this._v[i4][k] + y * this._v[i4][k + 1];
                    if (notlast) {
                        this._v[i4][k + 2] = this._v[i4][k + 2] - (p += z * this._v[i4][k + 2]) * r;
                    }
                    this._v[i4][k] = this._v[i4][k] - p;
                    this._v[i4][k + 1] = this._v[i4][k + 1] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = this._d[n];
            q = this._e[n];
            if (q == 0.0) {
                l = n;
                this._h[n][n] = 1.0;
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = this._h[i][i] - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += this._h[i][j4] * this._h[j4][n];
                    }
                    if (this._e[i] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (this._e[i] == 0.0) {
                        this._h[i][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = this._h[i][i + 1];
                        y = this._h[i + 1][i];
                        q = (this._d[i] - p) * (this._d[i] - p) + this._e[i] * this._e[i];
                        this._h[i][n] = t = (x * s - z * r) / q;
                        this._h[i + 1][n] = ArrayMath.abs(x) > ArrayMath.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = ArrayMath.abs(this._h[i][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        double[] dArray = this._h[j4];
                        int n4 = n;
                        dArray[n4] = dArray[n4] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (ArrayMath.abs(this._h[n][n - 1]) > ArrayMath.abs(this._h[n - 1][n])) {
                this._h[n - 1][n - 1] = q / this._h[n][n - 1];
                this._h[n - 1][n] = -(this._h[n][n] - p) / this._h[n][n - 1];
            } else {
                this.cdiv(0.0, -this._h[n - 1][n], this._h[n - 1][n - 1] - p, q);
                this._h[n - 1][n - 1] = this._cdivr;
                this._h[n - 1][n] = this._cdivi;
            }
            this._h[n][n - 1] = 0.0;
            this._h[n][n] = 1.0;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = 0.0;
                double sa = 0.0;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += this._h[i][j5] * this._h[j5][n - 1];
                    sa += this._h[i][j5] * this._h[j5][n];
                }
                w = this._h[i][i] - p;
                if (this._e[i] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (this._e[i] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this._h[i][n - 1] = this._cdivr;
                    this._h[i][n] = this._cdivi;
                } else {
                    x = this._h[i][i + 1];
                    y = this._h[i + 1][i];
                    double vr = (this._d[i] - p) * (this._d[i] - p) + this._e[i] * this._e[i] - q * q;
                    double vi = (this._d[i] - p) * 2.0 * q;
                    if (vr == 0.0 && vi == 0.0) {
                        vr = eps * norm * (ArrayMath.abs(w) + ArrayMath.abs(q) + ArrayMath.abs(x) + ArrayMath.abs(y) + ArrayMath.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    this._h[i][n - 1] = this._cdivr;
                    this._h[i][n] = this._cdivi;
                    if (ArrayMath.abs(x) > ArrayMath.abs(z) + ArrayMath.abs(q)) {
                        this._h[i + 1][n - 1] = (-ra - w * this._h[i][n - 1] + q * this._h[i][n]) / x;
                        this._h[i + 1][n] = (-sa - w * this._h[i][n] - q * this._h[i][n - 1]) / x;
                    } else {
                        this.cdiv(-r - y * this._h[i][n - 1], -s - y * this._h[i][n], z, q);
                        this._h[i + 1][n - 1] = this._cdivr;
                        this._h[i + 1][n] = this._cdivi;
                    }
                }
                t = ArrayMath.max(ArrayMath.abs(this._h[i][n - 1]), ArrayMath.abs(this._h[i][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i; j5 < n; ++j5) {
                    double[] dArray = this._h[j5];
                    int n5 = n - 1;
                    dArray[n5] = dArray[n5] / t;
                    double[] dArray2 = this._h[j5];
                    int n6 = n;
                    dArray2[n6] = dArray2[n6] / t;
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (i5 >= low && i5 <= high) continue;
            for (j = i5; j < nn; ++j) {
                this._v[i5][j] = this._h[i5][j];
            }
        }
        for (j2 = nn - 1; j2 >= low; --j2) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (int k = low; k <= ArrayMath.min(j2, high); ++k) {
                    z += this._v[i][k] * this._h[k][j2];
                }
                this._v[i][j2] = z;
            }
        }
    }
}

