/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.datagenerators.ClusterDefinition;
import weka.datagenerators.ClusterGenerator;
import weka.datagenerators.clusterers.SubspaceCluster;

public class SubspaceClusterDefinition
extends ClusterDefinition {
    static final long serialVersionUID = 3135678125044007231L;
    protected int m_clustertype = this.defaultClusterType().getSelectedTag().getID();
    protected int m_clustersubtype = this.defaultClusterSubType().getSelectedTag().getID();
    protected int m_MinInstNum = this.defaultMinInstNum();
    protected int m_MaxInstNum = this.defaultMaxInstNum();
    protected Range m_AttrIndexRange = new Range(this.defaultAttrIndexRange());
    protected String m_valuesList = this.defaultValuesList();
    protected int m_numClusterAttributes;
    protected int m_numInstances;
    protected boolean[] m_attributes;
    protected int[] m_attrIndices;
    protected double[] m_valueA;
    protected double[] m_valueB;

    public SubspaceClusterDefinition() {
    }

    public SubspaceClusterDefinition(ClusterGenerator parent) {
        super(parent);
    }

    @Override
    protected void setDefaults() throws Exception {
    }

    @Override
    public String globalInfo() {
        return "A single cluster for the SubspaceCluster datagenerator";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tUses a random uniform distribution for the instances in the cluster.", "A", 1, "-A <range>"));
        result.addElement(new Option("\tGenerates totally uniformly distributed instances in the cluster.", "U", 1, "-U <range>"));
        result.addElement(new Option("\tUses a Gaussian distribution for instances in the cluster.", "G", 1, "-G <range>"));
        result.addElement(new Option("\tThe attribute min/max (-A and -U) or mean/stddev (-G) for\n\tthe cluster, repeated for each attribute.", "D", 1, "-D <num>,<num>"));
        result.addElement(new Option("\tThe range of number of instances per cluster (default " + this.defaultMinInstNum() + ".." + this.defaultMaxInstNum() + ").", "N", 1, "-N <num>..<num>"));
        result.addElement(new Option("\tUses integer instead of continuous values (default continuous).", "I", 0, "-I"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        int typeCount = 0;
        String fromToStr = "";
        String tmpStr = Utils.getOption('A', options);
        if (tmpStr.length() != 0) {
            fromToStr = tmpStr;
            this.setClusterType(new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERTYPE));
            ++typeCount;
        }
        if ((tmpStr = Utils.getOption('U', options)).length() != 0) {
            fromToStr = tmpStr;
            this.setClusterType(new SelectedTag(1, SubspaceCluster.TAGS_CLUSTERTYPE));
            ++typeCount;
        }
        if ((tmpStr = Utils.getOption('G', options)).length() != 0) {
            fromToStr = tmpStr;
            this.setClusterType(new SelectedTag(2, SubspaceCluster.TAGS_CLUSTERTYPE));
            ++typeCount;
        }
        if (typeCount == 0) {
            this.setClusterType(new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERTYPE));
        } else if (typeCount > 1) {
            throw new Exception("Only one cluster type can be specified!");
        }
        this.setAttrIndexRange(fromToStr.length() > 0 ? fromToStr : this.defaultAttrIndexRange());
        tmpStr = Utils.getOption('D', options);
        if (tmpStr.length() != 0) {
            this.setValuesList(tmpStr);
        } else {
            this.setValuesList(this.defaultValuesList());
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setInstNums(tmpStr);
        } else {
            this.setInstNums(this.defaultMinInstNum() + ".." + this.defaultMaxInstNum());
        }
        if (Utils.getFlag('I', options)) {
            this.setClusterSubType(new SelectedTag(1, SubspaceCluster.TAGS_CLUSTERSUBTYPE));
        } else {
            this.setClusterSubType(new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERSUBTYPE));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.isRandom()) {
            result.add("-A");
            result.add("" + this.getAttrIndexRange());
        } else if (this.isUniform()) {
            result.add("-U");
            result.add("" + this.getAttrIndexRange());
        } else if (this.isGaussian()) {
            result.add("-G");
            result.add("" + this.getAttrIndexRange());
        }
        result.add("-D");
        result.add("" + this.getValuesList());
        result.add("-N");
        result.add("" + this.getInstNums());
        if (this.m_clustersubtype == 1) {
            result.add("-I");
        }
        return result.toArray(new String[result.size()]);
    }

    public String attributesToString() {
        StringBuffer text = new StringBuffer();
        int j = 0;
        for (int i = 0; i < this.m_attributes.length; ++i) {
            if (!this.m_attributes[i]) continue;
            if (this.isGaussian()) {
                text.append(" Attribute: " + i);
                text.append(" Mean: " + this.m_valueA[j]);
                text.append(" StdDev: " + this.m_valueB[j] + "\n%");
            } else {
                text.append(" Attribute: " + i);
                text.append(" Range: " + this.m_valueA[j]);
                text.append(" - " + this.m_valueB[j] + "\n%");
            }
            ++j;
        }
        return text.toString();
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("attributes " + this.attributesToString() + "\n");
        text.append("number of instances " + this.getInstNums());
        return text.toString();
    }

    protected String defaultAttrIndexRange() {
        return "1";
    }

    public void setAttrIndexRange(String rangeList) {
        this.m_AttrIndexRange.setRanges(rangeList);
    }

    public String getAttrIndexRange() {
        return this.m_AttrIndexRange.getRanges();
    }

    public String attrIndexRangeTipText() {
        return "The attribute range(s).";
    }

    public boolean[] getAttributes() {
        return this.m_attributes;
    }

    public double[] getMinValue() {
        return this.m_valueA;
    }

    public double[] getMaxValue() {
        return this.m_valueB;
    }

    public double[] getMeanValue() {
        return this.m_valueA;
    }

    public double[] getStddevValue() {
        return this.m_valueB;
    }

    public int getNumInstances() {
        return this.m_numInstances;
    }

    protected SelectedTag defaultClusterType() {
        return new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERTYPE);
    }

    public SelectedTag getClusterType() {
        return new SelectedTag(this.m_clustertype, SubspaceCluster.TAGS_CLUSTERTYPE);
    }

    public void setClusterType(SelectedTag value) {
        if (value.getTags() == SubspaceCluster.TAGS_CLUSTERTYPE) {
            this.m_clustertype = value.getSelectedTag().getID();
        }
    }

    public String clusterTypeTipText() {
        return "The type of cluster to use.";
    }

    protected SelectedTag defaultClusterSubType() {
        return new SelectedTag(0, SubspaceCluster.TAGS_CLUSTERSUBTYPE);
    }

    public SelectedTag getClusterSubType() {
        return new SelectedTag(this.m_clustersubtype, SubspaceCluster.TAGS_CLUSTERSUBTYPE);
    }

    public void setClusterSubType(SelectedTag value) {
        if (value.getTags() == SubspaceCluster.TAGS_CLUSTERSUBTYPE) {
            this.m_clustersubtype = value.getSelectedTag().getID();
        }
    }

    public String clusterSubTypeTipText() {
        return "The sub-type of cluster to use.";
    }

    public boolean isRandom() {
        return this.m_clustertype == 0;
    }

    public boolean isUniform() {
        return this.m_clustertype == 1;
    }

    public boolean isGaussian() {
        return this.m_clustertype == 2;
    }

    public boolean isContinuous() {
        return this.m_clustertype == 0;
    }

    public boolean isInteger() {
        return this.m_clustersubtype == 1;
    }

    protected void setInstNums(String fromTo) {
        int i = fromTo.indexOf("..");
        if (i == -1) {
            i = fromTo.length();
        }
        String from = fromTo.substring(0, i);
        this.m_MinInstNum = Integer.parseInt(from);
        if (i < fromTo.length()) {
            String to = fromTo.substring(i + 2, fromTo.length());
            this.m_MaxInstNum = Integer.parseInt(to);
        } else {
            this.m_MaxInstNum = this.m_MinInstNum;
        }
    }

    protected String getInstNums() {
        return new String("" + this.m_MinInstNum + ".." + this.m_MaxInstNum);
    }

    protected String instNumsTipText() {
        return "The lower and upper boundary for the number of instances in this cluster.";
    }

    protected int defaultMinInstNum() {
        return 1;
    }

    public int getMinInstNum() {
        return this.m_MinInstNum;
    }

    public void setMinInstNum(int newMinInstNum) {
        this.m_MinInstNum = newMinInstNum;
    }

    public String minInstNumTipText() {
        return "The lower boundary for instances per cluster.";
    }

    protected int defaultMaxInstNum() {
        return 50;
    }

    public int getMaxInstNum() {
        return this.m_MaxInstNum;
    }

    public void setMaxInstNum(int newMaxInstNum) {
        this.m_MaxInstNum = newMaxInstNum;
    }

    public String maxInstNumTipText() {
        return "The upper boundary for instances per cluster.";
    }

    public void setNumInstances(Random r) {
        this.m_numInstances = this.m_MaxInstNum > this.m_MinInstNum ? (int)(r.nextDouble() * (double)(this.m_MaxInstNum - this.m_MinInstNum) + (double)this.m_MinInstNum) : this.m_MinInstNum;
    }

    protected String defaultValuesList() {
        return "1,10";
    }

    public void setValuesList(String fromToList) throws Exception {
        this.m_valuesList = fromToList;
    }

    public String getValuesList() {
        return this.m_valuesList;
    }

    public String valuesListTipText() {
        return "The min (mean) and max (standard deviation) for each attribute as a comma-separated string.";
    }

    protected void initialiseMemberVariables() {
        this.m_numClusterAttributes = 0;
        if (this.getParent() != null) {
            this.m_AttrIndexRange.setUpper(this.getParent().getNumAttributes());
            this.m_attributes = new boolean[this.getParent().getNumAttributes()];
            for (int i = 0; i < this.m_attributes.length; ++i) {
                if (this.m_AttrIndexRange.isInRange(i)) {
                    ++this.m_numClusterAttributes;
                    this.m_attributes[i] = true;
                    continue;
                }
                this.m_attributes[i] = false;
            }
            this.m_attrIndices = new int[this.m_numClusterAttributes];
            int clusterI = -1;
            for (int i = 0; i < this.m_attributes.length; ++i) {
                if (!this.m_AttrIndexRange.isInRange(i)) continue;
                this.m_attrIndices[++clusterI] = i;
            }
        }
    }

    protected void setValues() throws Exception {
        this.m_valueA = new double[this.m_numClusterAttributes];
        this.m_valueB = new double[this.m_numClusterAttributes];
        StringTokenizer tok = new StringTokenizer(this.getValuesList(), ",");
        if (tok.countTokens() != this.m_valueA.length + this.m_valueB.length) {
            throw new Exception("Wrong number of values for option '-D'.");
        }
        int index = 0;
        while (tok.hasMoreTokens()) {
            this.m_valueA[index] = Double.parseDouble(tok.nextToken());
            this.m_valueB[index] = Double.parseDouble(tok.nextToken());
            ++index;
        }
        SubspaceCluster parent = (SubspaceCluster)this.getParent();
        for (int i = 0; i < this.m_numClusterAttributes; ++i) {
            if (!this.isGaussian() && this.m_valueA[i] > this.m_valueB[i]) {
                throw new Exception("Min must be smaller than max.");
            }
            if (this.getParent() == null) continue;
            if (parent.isBoolean(this.m_attrIndices[i])) {
                if (this.isGaussian()) {
                    throw new Exception("Cannot generate Gaussian values for Boolean attribute.");
                }
                if (!this.isInteger()) {
                    throw new Exception("Cannot generate non-integer values for Boolean attribute.");
                }
                parent.getNumValues()[this.m_attrIndices[i]] = 2;
                if ((this.m_valueA[i] == 0.0 || this.m_valueA[i] == 1.0) && (this.m_valueB[i] == 0.0 || this.m_valueB[i] == 1.0)) continue;
                throw new Exception("Ranges for boolean must be 0 or 1 only.");
            }
            if (!parent.isNominal(this.m_attrIndices[i])) continue;
            if (this.isGaussian()) {
                throw new Exception("Cannot generate Gaussian values for nominal attribute.");
            }
            if (!this.isInteger()) {
                throw new Exception("Cannot generate non-integer values for nominal attribute.");
            }
            double rest = this.m_valueA[i] - Math.rint(this.m_valueA[i]);
            if (rest != 0.0) {
                throw new Exception("Ranges for nominal must be integer");
            }
            rest = this.m_valueB[i] - Math.rint(this.m_valueB[i]);
            if (rest != 0.0) {
                throw new Exception("Ranges for nominal must be integer");
            }
            if (this.m_valueA[i] < 0.0) {
                throw new Exception("Range for nominal must start with number 0.0 or higher");
            }
            if (!(this.m_valueB[i] + 1.0 > (double)parent.getNumValues()[this.m_attrIndices[i]])) continue;
            parent.getNumValues()[this.m_attrIndices[i]] = (int)this.m_valueB[i] + 1;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15743 $");
    }
}

