/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AbstractTranslation;
import net.imglib2.realtransform.TranslationGet;

public class Translation2D
extends AbstractTranslation
implements Concatenable<TranslationGet>,
PreConcatenable<TranslationGet> {
    protected static final RealPoint[] constDs = new RealPoint[2];
    protected final Translation2D inverse;

    protected Translation2D(double[] t, Translation2D inverse) {
        super(t, constDs);
        Translation2D.constDs[0] = new RealPoint(new double[]{1.0, 0.0});
        Translation2D.constDs[1] = new RealPoint(new double[]{0.0, 1.0});
        assert (t.length == this.numDimensions()) : "Input dimensions do not match or are not 2.";
        this.inverse = inverse;
    }

    public Translation2D() {
        super(new double[2], constDs);
        Translation2D.constDs[0] = new RealPoint(new double[]{1.0, 0.0});
        Translation2D.constDs[1] = new RealPoint(new double[]{0.0, 1.0});
        this.inverse = new Translation2D(new double[2], this);
    }

    public Translation2D(double tx, double ty) {
        this();
        this.set(tx, ty);
    }

    public Translation2D(double ... t) {
        this();
        this.set(t);
    }

    public void set(double tx, double ty) {
        this.t[0] = tx;
        this.t[1] = ty;
        this.inverse.t[0] = -tx;
        this.inverse.t[1] = -ty;
    }

    @Override
    public void set(double ... t) {
        assert (t.length <= 2) : "Too many inputs.";
        try {
            this.t[0] = t[0];
            this.t[1] = t[1];
            this.inverse.t[0] = -t[0];
            this.inverse.t[1] = -t[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void set(double t, int d) {
        assert (d >= 0 && d < this.numDimensions()) : "Dimensions index out of bounds.";
        this.t[d] = t;
        this.inverse.t[d] = -t;
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        target[0] = source[0] + this.t[0];
        target[1] = source[1] + this.t[1];
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        target[0] = (float)((double)source[0] + this.t[0]);
        target[1] = (float)((double)source[1] + this.t[1]);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.numDimensions() && target.numDimensions() >= this.numDimensions()) : "Input dimensions too small.";
        target.setPosition(source.getDoublePosition(0) + this.t[0], 0);
        target.setPosition(source.getDoublePosition(1) + this.t[1], 1);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        source[0] = target[0] - this.t[0];
        source[1] = target[1] - this.t[1];
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= this.numDimensions() && target.length >= this.numDimensions()) : "Input dimensions too small.";
        source[0] = (float)((double)target[0] - this.t[0]);
        source[1] = (float)((double)target[1] - this.t[1]);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.numDimensions() && target.numDimensions() >= this.numDimensions()) : "Input dimensions too small.";
        source.setPosition(target.getDoublePosition(0) - this.t[0], 0);
        source.setPosition(target.getDoublePosition(1) - this.t[1], 1);
    }

    @Override
    public Translation2D copy() {
        return new Translation2D(this.t);
    }

    @Override
    public double[] getRowPackedCopy() {
        double[] matrix = new double[6];
        matrix[0] = 1.0;
        matrix[4] = 1.0;
        matrix[2] = this.t[0];
        matrix[5] = this.t[1];
        return matrix;
    }

    @Override
    public Translation2D inverse() {
        return this.inverse;
    }

    public Translation2D preConcatenate(TranslationGet a) {
        this.set(this.t[0] + a.getTranslation(0), this.t[1] + a.getTranslation(1));
        return this;
    }

    public Class<TranslationGet> getPreConcatenableClass() {
        return TranslationGet.class;
    }

    public Translation2D concatenate(TranslationGet a) {
        return this.preConcatenate(a);
    }

    public Class<TranslationGet> getConcatenableClass() {
        return TranslationGet.class;
    }

    @Override
    public boolean isIdentity() {
        return this.t[0] == 0.0 && this.t[1] == 0.0;
    }
}

