/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox;

import ij.IJ;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MasterModel {
    private static MasterModel masterModel;
    public static final String VERSION;
    public static boolean debugMode;
    public static char micro;
    public static String micrometer;
    public static byte NONE;
    public static byte CHANNEL;
    public static byte DEPTH;
    public static byte TIME;
    public String[] supportedBatchTypes = new String[]{"Tiff", "8-bit Tiff", "Jpeg", "Zip", "Raw"};
    public String[] macroFiles = new String[]{"magic_montage.txt"};
    public String[] macros = new String[this.macroFiles.length];

    private static String version() {
        String version = null;
        Package lsmPackage = MasterModel.class.getPackage();
        if (lsmPackage != null) {
            version = lsmPackage.getImplementationVersion();
        }
        return version == null ? "DEV" : version;
    }

    public static MasterModel getMasterModel() {
        if (masterModel == null) {
            masterModel = new MasterModel();
        }
        return masterModel;
    }

    public MasterModel() {
        this.initializeModel();
        this.registerServices();
        this.readMacros();
    }

    public void initializeModel() {
    }

    public void readMacros() {
        for (int i = 0; i < this.macroFiles.length; ++i) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/imagearchive/lsm/toolbox/macros/" + this.macroFiles[i]);
            try {
                String line;
                if (in == null) {
                    throw new IOException();
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuffer macroBuffer = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    macroBuffer.append(line + "\n");
                }
                this.macros[i] = macroBuffer.toString();
                reader.close();
                continue;
            }
            catch (IOException e) {
                this.macros[i] = null;
                IJ.error((String)"Could not load internal macro.");
            }
        }
    }

    private void registerServices() {
    }

    public String getVersion() {
        return VERSION;
    }

    public String getMacro(int i) {
        if (i >= 0 && i < this.macros.length) {
            return this.macros[i];
        }
        return null;
    }

    public String getMagicMontaqe() {
        StringBuffer sb = new StringBuffer();
        String ext_macro = null;
        float ext_ver = 0.0f;
        float int_ver = 0.0f;
        String int_macro = new String();
        String toolsSetDir = IJ.getDirectory((String)"macros") + File.separator + "toolsets";
        try {
            File f = new File(toolsSetDir + File.separator + "magic_montage.txt");
            BufferedReader input = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = input.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            input.close();
            ext_macro = sb.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ext_macro != null) {
            try {
                ext_ver = Float.parseFloat(ext_macro.substring(ext_macro.indexOf("//--version--") + 13, ext_macro.indexOf("\n")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((int_macro = this.getMacro(0)) != null) {
            try {
                int_ver = Float.parseFloat(int_macro.substring(int_macro.indexOf("//--version--") + 13, int_macro.indexOf("\n")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (int_ver < ext_ver) {
            return ext_macro;
        }
        return int_macro;
    }

    static {
        VERSION = MasterModel.version();
        debugMode = false;
        micro = (char)181;
        micrometer = micro + "m";
        NONE = 0;
        CHANNEL = 1;
        DEPTH = (byte)2;
        TIME = (byte)3;
    }
}

