/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class ReaderToolkit {
    public static short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    public static char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    public static int swap(int x) {
        return ReaderToolkit.swap((short)x) << 16 | ReaderToolkit.swap((short)(x >> 16)) & 0xFFFF;
    }

    public static long swap(long x) {
        return (long)ReaderToolkit.swap((int)x) << 32 | (long)ReaderToolkit.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public static float swap(float x) {
        return Float.intBitsToFloat(ReaderToolkit.swap(Float.floatToIntBits(x)));
    }

    public static double swap(double x) {
        return Double.longBitsToDouble(ReaderToolkit.swap(Double.doubleToLongBits(x)));
    }

    public static String readSizedNULLASCII(RandomAccessStream stream, long s) {
        int offset = 0;
        String tempstr = new String("");
        int in = 0;
        boolean addchar = true;
        try {
            while ((long)offset < s && (in = stream.read()) != -1) {
                char ch = (char)in;
                if (addchar) {
                    String achar = new Character(ch).toString();
                    if (ch != '\u0000') {
                        tempstr = tempstr + achar;
                    } else {
                        addchar = false;
                    }
                }
                ++offset;
            }
        }
        catch (IOException Read_ASCII_exception) {
            Read_ASCII_exception.printStackTrace();
        }
        return tempstr;
    }

    public static String readASCII(RandomAccessStream stream, long length) {
        String rtn = "";
        try {
            int i = 0;
            while ((long)i < length) {
                rtn = rtn + (char)stream.read();
                ++i;
            }
        }
        catch (IOException Read_ASCII_exception) {
            Read_ASCII_exception.printStackTrace();
        }
        return rtn;
    }

    public static String readNULLASCII(RandomAccessStream stream) {
        String rtn = "";
        try {
            char ch;
            do {
                if ((ch = (char)stream.read()) == '\u0000') continue;
                rtn = rtn + ch;
            } while (ch != '\u0000');
        }
        catch (IOException Read_ASCII_exception) {
            Read_ASCII_exception.printStackTrace();
        }
        return rtn;
    }

    public static String readNULLASCII2(RandomAccessStream stream, long s) {
        int offset = 0;
        String tempstr = new String("");
        int in = 0;
        try {
            while ((long)offset < s && (in = stream.read()) != -1) {
                char ch = (char)in;
                if (ch == '\u0000') {
                    return tempstr;
                }
                tempstr = tempstr + Character.toString(ch);
                ++offset;
            }
        }
        catch (IOException Read_ASCII_exception) {
            Read_ASCII_exception.printStackTrace();
        }
        return tempstr;
    }

    public static void applyColors(ImagePlus imp, int channel, Color[] gc, int i) {
        FileInfo fi = new FileInfo();
        int size = 256;
        fi.reds = new byte[256];
        fi.greens = new byte[256];
        fi.blues = new byte[256];
        fi.lutSize = 256;
        float nColorsfl = 256.0f;
        float interval = 256.0f;
        float iR = gc[0].getRed();
        float iG = gc[0].getGreen();
        float iB = gc[0].getBlue();
        float idR = gc[1].getRed() - gc[0].getRed();
        float idG = gc[1].getGreen() - gc[0].getGreen();
        float idB = gc[1].getBlue() - gc[0].getBlue();
        idR /= 256.0f;
        idG /= 256.0f;
        idB /= 256.0f;
        int a = 0;
        a = 0;
        while (a < 256) {
            fi.reds[a] = (byte)iR;
            fi.greens[a] = (byte)iG;
            fi.blues[a] = (byte)iB;
            ++a;
            iR += idR;
            iG += idG;
            iB += idB;
        }
        int b = 255;
        fi.reds[255] = (byte)gc[1].getRed();
        fi.greens[255] = (byte)gc[1].getGreen();
        fi.blues[255] = (byte)gc[1].getBlue();
        nColorsfl = 256.0f;
        if (nColorsfl > 0.0f) {
            if (nColorsfl < 256.0f) {
                ReaderToolkit.interpolate(256, fi.reds, fi.greens, fi.blues, (int)nColorsfl);
            }
            ReaderToolkit.showLut(imp, channel, fi, true);
            return;
        }
    }

    private static void interpolate(int size, byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (float)nColors / (float)size;
        for (int i = 0; i < size; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }

    public static void showLut(ImagePlus imp, int channel, FileInfo fi, boolean showImage) {
        if (imp != null) {
            if (imp.getType() == 4) {
                IJ.error((String)"Color tables cannot be assiged to RGB Images.");
            } else {
                IndexColorModel cm = null;
                cm = new IndexColorModel(8, 256, fi.reds, fi.greens, fi.blues);
                imp.setPosition(channel + 1, imp.getSlice(), imp.getFrame());
                if (imp.isComposite()) {
                    ((CompositeImage)imp).setChannelColorModel(cm);
                    ((CompositeImage)imp).updateChannelAndDraw();
                } else {
                    imp.getProcessor().setColorModel((ColorModel)cm);
                    imp.updateAndDraw();
                }
            }
        }
    }
}

