/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.imagearchive.lsm.toolbox.Reader;
import org.imagearchive.lsm.toolbox.ServiceMediator;
import org.imagearchive.lsm.toolbox.gui.ControlPanelFrame;

public class CPDragAndDrop
implements DropTargetListener {
    protected static ImageJ ij = null;
    private static boolean enableDND = true;
    protected DataFlavor dFlavor;
    private ControlPanelFrame cp;

    public CPDragAndDrop(ControlPanelFrame cp) {
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.3.1") < 0) {
            return;
        }
        this.cp = cp;
        DropTarget dropTarget = new DropTarget(cp, this);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(1);
        try {
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                for (final File file : (List)data) {
                    final Reader reader = ServiceMediator.getReader();
                    SwingUtilities.invokeLater(new Runnable(){
                        ImageWindow iwc = null;

                        @Override
                        public void run() {
                            try {
                                IJ.showStatus((String)"Loading image");
                                ImagePlus imp = reader.open(file.getAbsolutePath(), true);
                                IJ.showStatus((String)"Image loaded");
                                if (imp == null) {
                                    return;
                                }
                                imp.setPosition(1, 1, 1);
                                imp.show();
                            }
                            catch (OutOfMemoryError e) {
                                IJ.outOfMemory((String)"Could not load lsm image.");
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

