/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import ij.ImagePlus;
import ij.io.RandomAccessStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.imagearchive.lsm.reader.Reader;

public class ImagePreview
extends JPanel
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    ImagePlus imp = null;
    JSlider slider = new JSlider(1, 1, 1);
    File file = null;
    Reader reader;
    JPanel panel;
    Color backgroundcolor = SystemColor.window;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(138, 50));
        fc.addPropertyChangeListener(this);
        this.reader = new Reader();
        this.setLayout(new BorderLayout());
        this.add((Component)this.slider, "North");
        this.slider.setPaintLabels(true);
        this.addSliderListener();
        this.backgroundcolor = this.getBackground();
    }

    private void addSliderListener() {
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ImagePreview.this.imp != null) {
                    ImagePreview.this.imp.setSlice(ImagePreview.this.slider.getValue());
                    ImageIcon tmpIcon = new ImageIcon(ImagePreview.this.imp.getProcessor().createImage());
                    if (tmpIcon != null) {
                        ImagePreview.this.thumbnail = tmpIcon.getIconWidth() > 128 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(128, -1, 1)) : tmpIcon;
                    }
                    ImagePreview.this.repaint();
                }
            }
        });
    }

    public void loadImage() {
        ImageIcon tmpIcon;
        block7: {
            if (this.file == null) {
                this.thumbnail = null;
                this.imp = null;
                return;
            }
            tmpIcon = null;
            try {
                RandomAccessStream stream = new RandomAccessStream(new RandomAccessFile(this.file, "r"));
                if (!this.reader.isLSMfile(stream)) break block7;
                this.imp = this.reader.open(this.file.getParent(), this.file.getName(), false, true);
                if (this.imp != null) {
                    this.slider.setValue(1);
                    this.slider.setMaximum(this.imp.getNSlices());
                    if (this.imp.getNSlices() == 1) {
                        this.slider.setVisible(false);
                    } else {
                        this.slider.setLabelTable(this.slider.createStandardLabels(this.imp.getNSlices() - 1));
                        this.slider.setVisible(true);
                    }
                    tmpIcon = new ImageIcon(this.imp.getImage());
                    break block7;
                }
                this.thumbnail = null;
                this.imp = null;
                return;
            }
            catch (IOException e) {
                this.thumbnail = null;
                this.imp = null;
                return;
            }
        }
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon.getIconWidth() > 128 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(128, -1, 1)) : tmpIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2 + this.slider.getHeight();
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            g.setColor(this.backgroundcolor);
            g.fillRect(this.slider.getX(), this.slider.getY(), this.getWidth(), this.getHeight());
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

