/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.network.client.ArchipelagoClient;
import edu.utexas.clm.archipelago.ui.ClusterUI;
import edu.utexas.clm.archipelago.util.IJLogger;
import edu.utexas.clm.archipelago.util.IJPopupLogger;
import edu.utexas.clm.archipelago.util.PrintStreamLogger;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Fiji_Archipelago
implements PlugIn {
    public void run(String arg) {
        if (arg.equals("gui")) {
            FijiArchipelago.setDebugLogger(new PrintStreamLogger());
            FijiArchipelago.setInfoLogger(new IJLogger());
            FijiArchipelago.setErrorLogger(new IJPopupLogger());
            new ClusterUI();
        } else if (arg.equals("client")) {
            FijiArchipelago.runClientGUI();
        } else if (!arg.equals("")) {
            FijiArchipelago.runClusterGUI(arg);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        OutputStream os;
        InputStream is;
        long id = -1L;
        Socket s = null;
        FijiArchipelago.log("Main called at " + new Date());
        switch (args.length) {
            case 3: {
                id = Long.parseLong(args[2]);
            }
            case 2: {
                s = new Socket(args[0], Integer.parseInt(args[1]));
                is = s.getInputStream();
                os = s.getOutputStream();
                break;
            }
            case 1: {
                id = Long.parseLong(args[0]);
                is = System.in;
                os = System.out;
                break;
            }
            default: {
                System.err.println("Usage: Fiji_Archipelago [host port] [ID]");
                return;
            }
        }
        String datetimeStrStart = new SimpleDateFormat("yyMMdd'T'HHmm").format(new Date());
        File logFile = new File(System.getProperty("user.home") + "/cluster_" + id + "_" + datetimeStrStart + ".log");
        PrintStream filePrinter = new PrintStream(new FileOutputStream(logFile));
        System.setOut(filePrinter);
        System.setErr(filePrinter);
        FijiArchipelago.setDebugLogger(new PrintStreamLogger(filePrinter));
        FijiArchipelago.setErrorLogger(new PrintStreamLogger(filePrinter));
        FijiArchipelago.setInfoLogger(new PrintStreamLogger(filePrinter));
        FijiArchipelago.log(args.length == 1 ? "Using System.in/out" : "Using socket");
        ArchipelagoClient client = new ArchipelagoClient(id, is, os);
        while (client.isActive()) {
            Thread.sleep(1000L);
        }
        FijiArchipelago.log("Client is inactive, closing...");
        if (s != null) {
            s.close();
        }
        filePrinter.close();
        System.exit(0);
    }
}

