/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.example;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.compute.ArchipelagoFuture;
import ij.IJ;
import ij.plugin.PlugIn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class Stress_Test
implements PlugIn {
    public void run(String arg) {
        Cluster cluster = Cluster.getCluster();
        int startNum = 1024;
        if (!cluster.isReady()) {
            IJ.error((String)"Cluster is not ready");
        } else {
            ExecutorService service = cluster.getService(1);
            ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>(startNum);
            for (int i = 0; i < startNum; ++i) {
                futures.add(service.submit(new Stressor()));
            }
            while (!futures.isEmpty()) {
                try {
                    Future future = (Future)futures.get(0);
                    if (future instanceof ArchipelagoFuture) {
                        ArchipelagoFuture archf = (ArchipelagoFuture)future;
                        IJ.log((String)("Waiting for future " + archf.getID() + "..."));
                    } else {
                        IJ.log((String)"Waiting for the future...");
                    }
                    Double d = (Double)future.get();
                    IJ.log((String)"The future came!");
                    futures.remove(0);
                    futures.add(service.submit(new Stressor()));
                }
                catch (ExecutionException ee) {
                    IJ.log((String)"The future had a problem.");
                    ee.printStackTrace();
                    IJ.log((String)("Caught Exception: " + ee));
                }
                catch (InterruptedException ie) {
                    IJ.log((String)"Interrupted while running.");
                    return;
                }
            }
            IJ.log((String)"Done!");
        }
    }

    public static class Stressor
    implements Callable<Double>,
    Serializable {
        private final int stresses;

        public Stressor() {
            this.stresses = 0x100000;
        }

        @Override
        public Double call() throws Exception {
            Random r = new Random(System.currentTimeMillis());
            double rval = r.nextDouble();
            for (int i = 0; i < this.stresses; ++i) {
                double rval2 = r.nextDouble();
                rval2 *= rval2;
                rval2 = Math.pow(rval2, rval);
                rval = rval2 /= (double)i;
            }
            return rval;
        }
    }
}

