/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractHasSource;
import io.scif.DefaultImageMetadata;
import io.scif.DefaultMetaTable;
import io.scif.Field;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.Metadata;
import io.scif.TypedMetadata;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public abstract class AbstractMetadata
extends AbstractHasSource
implements TypedMetadata {
    private transient DataHandle<Location> source;
    private transient Location sourceLocation;
    private transient Location destinationLocation;
    private boolean filtered;
    private transient List<ImageMetadata> imageMeta = new ArrayList<ImageMetadata>();
    private String datasetName = null;
    private MetaTable table = new DefaultMetaTable();

    public AbstractMetadata() {
        this((List<ImageMetadata>)null);
    }

    public AbstractMetadata(Metadata copy) {
        this(copy.getAll());
        this.table = new DefaultMetaTable(copy.getTable());
    }

    public AbstractMetadata(List<ImageMetadata> list) {
        if (list != null) {
            for (ImageMetadata core : list) {
                this.imageMeta.add(core.copy());
            }
        }
    }

    @Override
    public void setSource(DataHandle<Location> source) {
        this.source = source;
        if (source != null) {
            this.setDatasetName(((Location)source.get()).getName());
        }
    }

    @Override
    public void setSourceLocation(Location loc) {
        this.sourceLocation = loc;
    }

    @Override
    public Location getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public Location getDestinationLocation() {
        return this.destinationLocation;
    }

    @Override
    public void setDestinationLocation(Location loc) {
        this.destinationLocation = loc;
    }

    @Override
    public DataHandle<Location> getSource() {
        return this.source;
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public ImageMetadata get(int imageIndex) {
        return this.imageMeta.get(imageIndex);
    }

    @Override
    public List<ImageMetadata> getAll() {
        return this.imageMeta;
    }

    @Override
    public int getImageCount() {
        return this.imageMeta.size();
    }

    @Override
    public long getDatasetSize() {
        long size = 0L;
        for (int i = 0; i < this.getAll().size(); ++i) {
            size += this.get(i).getSize();
        }
        return size;
    }

    @Override
    public void setDatasetName(String name) {
        this.datasetName = name;
    }

    @Override
    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    @Override
    public void add(ImageMetadata meta) {
        this.imageMeta.add(meta);
    }

    @Override
    public void createImageMetadata(int imageCount) {
        this.imageMeta.clear();
        for (int i = 0; i < imageCount; ++i) {
            this.add(new DefaultImageMetadata());
        }
    }

    @Override
    public MetaTable getTable() {
        if (this.table == null) {
            this.table = new DefaultMetaTable(this.isFiltered());
        }
        return this.table;
    }

    @Override
    public void setTable(MetaTable table) {
        this.table = table;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.source != null) {
            this.source.close();
        }
        if (!fileOnly) {
            this.reset(this.getClass());
        }
    }

    private void reset(Class<?> type) {
        if (type == null || type == AbstractMetadata.class) {
            return;
        }
        for (java.lang.reflect.Field f : type.getDeclaredFields()) {
            f.setAccessible(true);
            if (Modifier.isFinal(f.getModifiers()) || f.getAnnotation(Field.class) == null) continue;
            Class<?> fieldType = f.getType();
            try {
                if (fieldType == Boolean.TYPE) {
                    f.set(this, false);
                } else if (fieldType == Character.TYPE) {
                    f.set(this, 0);
                } else if (fieldType == Double.TYPE) {
                    f.set(this, 0.0);
                } else if (fieldType == Float.TYPE) {
                    f.set(this, Float.valueOf(0.0f));
                } else if (fieldType == Integer.TYPE) {
                    f.set(this, 0);
                } else if (fieldType == Long.TYPE) {
                    f.set(this, 0L);
                } else if (fieldType == Short.TYPE) {
                    f.set(this, 0);
                } else {
                    f.set(this, null);
                }
            }
            catch (IllegalArgumentException e) {
                this.log().debug((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.log().debug((Object)e.getMessage());
            }
            this.table = new DefaultMetaTable();
            this.imageMeta = new ArrayList<ImageMetadata>();
            this.reset(type.getSuperclass());
            for (Class<?> c : type.getInterfaces()) {
                this.reset(c);
            }
        }
    }
}

