/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.FilePattern;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;

public class AxisGuesser {
    public static final int UNKNOWN_AXIS = 0;
    public static final int Z_AXIS = 1;
    public static final int T_AXIS = 2;
    public static final int C_AXIS = 3;
    public static final int S_AXIS = 4;
    private static final String[] Z = new String[]{"fp", "sec", "z", "zs", "focal", "focalplane"};
    private static final String[] T = new String[]{"t", "tl", "tp", "time"};
    private static final String[] C = new String[]{"c", "ch", "w", "wavelength"};
    private static final String[] S = new String[]{"s", "series", "sp"};
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String THREE = "3";
    private final FilePattern fp;
    private final AxisType[] dimOrder;
    private final AxisType[] newOrder;
    private int[] axisTypes;
    private boolean certain;

    public AxisGuesser(FilePattern fp, AxisType[] dimOrder, long sizeZ, long sizeT, long sizeC, boolean isCertain) {
        this.fp = fp;
        this.dimOrder = dimOrder;
        this.newOrder = dimOrder;
        String[] prefixes = fp.getPrefixes();
        String suffix = fp.getSuffix();
        String[][] elements = fp.getElements();
        this.axisTypes = new int[elements.length];
        boolean foundZ = false;
        boolean foundT = false;
        boolean foundC = false;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            int third;
            int f;
            int l;
            String p = prefixes[i].toLowerCase();
            char[] ch = p.toCharArray();
            for (l = ch.length - 1; l >= 0 && (ch[l] >= '0' && ch[l] <= '9' || ch[l] == ' ' || ch[l] == '-' || ch[l] == '_' || ch[l] == '.'); --l) {
            }
            for (f = l; f >= 0 && ch[f] >= 'a' && ch[f] <= 'z'; --f) {
            }
            p = p.substring(f + 1, l + 1);
            for (String zPre : Z) {
                if (!p.equals(zPre)) continue;
                this.axisTypes[i] = 1;
                foundZ = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (String tPre : T) {
                if (!p.equals(tPre)) continue;
                this.axisTypes[i] = 2;
                foundT = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (String cPre : C) {
                if (!p.equals(cPre)) continue;
                this.axisTypes[i] = 3;
                foundC = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (String sPre : S) {
                if (!p.equals(sPre)) continue;
                this.axisTypes[i] = 4;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            if (suffix.equalsIgnoreCase(".pic") && i == this.axisTypes.length - 1 && (elements[i].length == 2 && (elements[i][0].equals(ONE) || elements[i][0].equals(TWO)) && (elements[i][1].equals(TWO) || elements[i][1].equals(THREE)) || elements[i].length == 3 && elements[i][0].equals(ONE) && elements[i][1].equals(TWO) && elements[i][2].equals(THREE))) {
                this.axisTypes[i] = 3;
                continue;
            }
            if (elements[i].length != 2 && elements[i].length != 3) continue;
            char first = elements[i][0].toLowerCase().charAt(0);
            char second = elements[i][1].toLowerCase().charAt(0);
            int n = third = elements[i].length == 2 ? 98 : (int)elements[i][2].toLowerCase().charAt(0);
            if (first != 'r' && second != 'r' && third != 114 || first != 'g' && second != 'g' && third != 103 || first != 'b' && second != 'b' && third != 98) continue;
            this.axisTypes[i] = 3;
        }
        if (!isCertain && (foundZ && !foundT && sizeZ > 1L && sizeT == 1L || foundT && !foundZ && sizeT > 1L && sizeZ == 1L)) {
            int indexZ = this.indexOf(this.newOrder, Axes.Z);
            int indexT = this.indexOf(this.newOrder, Axes.TIME);
            long sz = sizeT;
            this.newOrder[indexZ] = Axes.TIME;
            this.newOrder[indexT] = Axes.Z;
            sizeT = sizeZ;
            sizeZ = sz;
        }
        boolean canBeZ = !foundZ && sizeZ == 1L;
        boolean canBeT = !foundT && sizeT == 1L;
        boolean canBeC = !foundC && sizeC == 1L;
        this.certain = isCertain;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != 0) continue;
            this.certain = false;
            if (canBeZ) {
                this.axisTypes[i] = 1;
                canBeZ = false;
                continue;
            }
            if (canBeT) {
                this.axisTypes[i] = 2;
                canBeT = false;
                continue;
            }
            if (canBeC) {
                this.axisTypes[i] = 3;
                canBeC = false;
                continue;
            }
            AxisType lastAxis = this.newOrder[this.newOrder.length - 1];
            this.axisTypes[i] = lastAxis.equals(Axes.CHANNEL) ? 3 : (lastAxis.equals(Axes.Z) ? 1 : 2);
        }
    }

    public FilePattern getFilePattern() {
        return this.fp;
    }

    public AxisType[] getOriginalOrder() {
        return this.dimOrder;
    }

    public AxisType[] getAdjustedOrder() {
        return this.newOrder;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public AxisType[] getAxisTypes() {
        AxisType[] out = new AxisType[this.axisTypes.length];
        for (int i = 0; i < out.length; ++i) {
            int t = this.axisTypes[i];
            if (t == 3) {
                out[i] = Axes.CHANNEL;
                continue;
            }
            if (t == 2) {
                out[i] = Axes.TIME;
                continue;
            }
            if (t == 1) {
                out[i] = Axes.Z;
                continue;
            }
            if (t == 0) {
                out[i] = Axes.unknown();
                continue;
            }
            if (t != 4) continue;
            out[i] = Axes.get((String)"Series");
        }
        return out;
    }

    public void setAxisTypes(int[] axes) {
        this.axisTypes = axes;
    }

    public int getAxisCountZ() {
        return this.getAxisCount(1);
    }

    public int getAxisCountT() {
        return this.getAxisCount(2);
    }

    public int getAxisCountC() {
        return this.getAxisCount(3);
    }

    public int getAxisCountS() {
        return this.getAxisCount(4);
    }

    public int getAxisCount(int axisType) {
        int num = 0;
        for (int type : this.axisTypes) {
            if (type != axisType) continue;
            ++num;
        }
        return num;
    }

    public static int getAxisType(String label) {
        String lowerLabel = label.toLowerCase();
        for (String p : Z) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 1;
        }
        for (String p : C) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 3;
        }
        for (String p : T) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 2;
        }
        for (String p : S) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 4;
        }
        return 0;
    }

    private int indexOf(AxisType[] axes, AxisType type) {
        int index = -1;
        for (int i = 0; i < axes.length && index == -1; ++i) {
            if (!axes[i].equals(type)) continue;
            index = i;
        }
        return index;
    }
}

