/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.common.DateTools;
import io.scif.config.SCIFIOConfig;
import io.scif.img.axes.SCIFIOAxes;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleInputStream;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Image Cytometry Standard")
public class ICSFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"ics", "ids"};
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class ICSTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            String byteOrder;
            Map<String, String> keyValPairs = null;
            keyValPairs = dest.getKeyValPairs() == null ? new HashMap<String, String>() : dest.getKeyValPairs();
            int numAxes = source.get(0).getAxes().size();
            String order = "";
            String sizes = "";
            String units = "";
            for (int i = 0; i < numAxes; ++i) {
                CalibratedAxis axis = source.get(0).getAxis(i);
                AxisType axisType = axis.type();
                if (axisType.equals(Axes.X)) {
                    order = order + "x";
                } else if (axisType.equals(Axes.Y)) {
                    order = order + "y";
                } else if (axisType.equals(Axes.Z)) {
                    order = order + "z";
                } else if (axisType.equals(Axes.TIME)) {
                    order = order + "t";
                } else if (axisType.equals(Axes.CHANNEL)) {
                    if (source.get(0).isMultichannel()) {
                        order = "c " + order;
                        sizes = source.get(0).getAxisLength(i) + " " + sizes;
                        units = units + axis.unit() + " ";
                        continue;
                    }
                    order = order + "c";
                } else {
                    order = axisType.equals(SCIFIOAxes.PHASE) ? order + "p" : (axisType.equals(SCIFIOAxes.FREQUENCY) ? order + "f" : (axisType.getLabel().equals("bits") ? order + "bits" : order + "u"));
                }
                order = order + " ";
                sizes = sizes + source.get(0).getAxisLength(i) + " ";
                units = units + axis.unit() + " ";
            }
            keyValPairs.put("layout sizes", sizes);
            keyValPairs.put("layout order", order);
            keyValPairs.put("parameter units", units);
            keyValPairs.put("layout significant_bits", "" + source.get(0).getBitsPerPixel());
            if (source.get(0).getAxisLength(SCIFIOAxes.LIFETIME) > 1L) {
                keyValPairs.put("history type", "time resolved");
            }
            boolean signed = false;
            boolean fPoint = false;
            switch (source.get(0).getPixelType()) {
                case 0: 
                case 2: 
                case 4: {
                    signed = true;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    fPoint = true;
                    signed = true;
                }
            }
            keyValPairs.put("representation sign", signed ? "signed" : "");
            keyValPairs.put("representation format", fPoint ? "real" : "");
            keyValPairs.put("representation compression", "");
            if (source.get(0).isLittleEndian()) {
                byteOrder = fPoint ? "1" : "0";
            } else {
                String string = byteOrder = fPoint ? "0" : "1";
            }
            if (source.get(0).getBitsPerPixel() < 32) {
                byteOrder = "0".equals(byteOrder) ? "1" : "0";
            }
            keyValPairs.put("representation byte_order", byteOrder);
            List<CalibratedAxis> axes = source.get(0).getAxes();
            String scale = "";
            for (int i = 0; i < axes.size(); ++i) {
                scale = scale + axes.get(i).averageScale(0.0, 1.0) + " ";
            }
            keyValPairs.put("parameter scale", scale);
            dest.setKeyValPairs(keyValPairs);
        }
    }

    public static class ICSUtils {
        private static final String[] NL = new String[]{"\n", "\r\n", "\r"};
        public static final String LEAF = "VALID_LEAF";
        public static final String[] DATE_FORMATS = new String[]{"EEEE, MMMM dd, yyyy HH:mm:ss", "EEE dd MMMM yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EE dd MMM yyyy HH:mm:ss z", "HH:mm:ss dd\\MM\\yy"};
        public static String[][] OTHER_KEYS = new String[][]{{"cube", "descriptio"}, {"cube", "description"}, {"image", "form"}, {"refinxlensmedium"}, {"refinxmedium"}, {"scil_type"}, {"source"}};
        public static final Map<String, Object> keys = ICSUtils.createKeyMap();

        private ICSUtils() {
        }

        private static Map<String, Object> createKeyMap() {
            HashMap<String, Object> root = new HashMap<String, Object>();
            ICSUtils.addKey(root, "ics_version");
            ICSUtils.addKey(root, "parameter", "ch");
            ICSUtils.addKey(root, "parameter", "scale");
            ICSUtils.addKey(root, "parameter", "t");
            ICSUtils.addKey(root, "parameter", "units");
            ICSUtils.addKey(root, "parameter", "labels");
            ICSUtils.addKey(root, "sensor", "s_params", "lambdaem");
            ICSUtils.addKey(root, "sensor", "s_params", "lambdaex");
            ICSUtils.addKey(root, "sensor", "s_params", "pinholeradius");
            ICSUtils.addKey(root, "representation", "byte_order");
            ICSUtils.addKey(root, "representation", "compression");
            ICSUtils.addKey(root, "representation", "format");
            ICSUtils.addKey(root, "representation", "sign");
            ICSUtils.addKey(root, "history", "author");
            ICSUtils.addKey(root, "history", "camera", "manufcaturer");
            ICSUtils.addKey(root, "history", "camera", "model");
            ICSUtils.addKey(root, "history", "cube", "emm", "nm");
            ICSUtils.addKey(root, "history", "cube", "exc", "nm");
            ICSUtils.addKey(root, "history", "date");
            ICSUtils.addKey(root, "history", "creation", "date");
            ICSUtils.addKey(root, "history", "created", "on");
            ICSUtils.addKey(root, "history", "experimenter");
            ICSUtils.addKey(root, "history", "exposure");
            ICSUtils.addKey(root, "history", "extents");
            ICSUtils.addKey(root, "history", "units");
            ICSUtils.addKey(root, "history", "filterset");
            ICSUtils.addKey(root, "history", "filterset", "dichroic", "name");
            ICSUtils.addKey(root, "history", "filterset", "emm", "name");
            ICSUtils.addKey(root, "history", "filterset", "exc", "name");
            ICSUtils.addKey(root, "history", "gain");
            ICSUtils.addKey(root, "history", "laser", "manufacturer");
            ICSUtils.addKey(root, "history", "laser", "model");
            ICSUtils.addKey(root, "history", "laser", "rep", "rate");
            ICSUtils.addKey(root, "history", "laser", "power");
            ICSUtils.addKey(root, "history", "labels");
            ICSUtils.addKey(root, "history", "manufacturer");
            ICSUtils.addKey(root, "history", "microscope");
            ICSUtils.addKey(root, "history", "objective", "type");
            ICSUtils.addKey(root, "history", "objective", "immersion");
            ICSUtils.addKey(root, "history", "objective", "na");
            ICSUtils.addKey(root, "history", "objective", "workingdistance");
            ICSUtils.addKey(root, "history", "objective", "magnification");
            ICSUtils.addKey(root, "history", "objective", "mag");
            ICSUtils.addKey(root, "history", "other", "text");
            ICSUtils.addKey(root, "history", "stage", "positionx");
            ICSUtils.addKey(root, "history", "stage", "positiony");
            ICSUtils.addKey(root, "history", "stage", "positionz");
            ICSUtils.addKey(root, "history", "stage_xyzum");
            ICSUtils.addKey(root, "history", "step");
            ICSUtils.addKey(root, "history", "type");
            ICSUtils.addKey(root, "history", "wavelength*");
            ICSUtils.addKey(root, "layout", "order");
            ICSUtils.addKey(root, "layout", "significant_bits");
            ICSUtils.addKey(root, "layout", "sizes");
            return root;
        }

        private static void addKey(Map<String, Object> parent, String ... keys) {
            if (keys.length == 0) {
                parent.put(LEAF, LEAF);
            } else {
                String node = keys[0];
                Object o = parent.get(node);
                HashMap<String, Object> child = null;
                if (o == null) {
                    child = new HashMap<String, Object>();
                    parent.put(node, child);
                } else {
                    child = (HashMap<String, Object>)o;
                }
                ICSUtils.addKey(child, Arrays.copyOfRange(keys, 1, keys.length));
            }
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        @Parameter
        private DataHandleService dataHandleService;
        private long dimensionOffset;
        private int dimensionLength;
        private long pixelOffset;
        private long lastPlane = -1L;
        private DataHandle<Location> pixels;

        @Override
        protected String[] makeCompressionTypes() {
            return new String[0];
        }

        @Override
        protected void initialize(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
            if (!this.isInitialized(imageIndex, (int)planeIndex) && !SCIFIOMetadataTools.wholePlane(imageIndex, this.getMetadata(), bounds)) {
                this.pixels.seek(this.pixelOffset + (planeIndex + 1L) * ((Metadata)this.getMetadata()).get(imageIndex).getPlaneSize());
            }
            super.initialize(imageIndex, planeIndex, bounds);
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
            this.checkParams(imageIndex, planeIndex, plane.getBytes(), bounds);
            Metadata meta = (Metadata)this.getMetadata();
            boolean interleaved = plane.getImageMetadata().getInterleavedAxisCount() > 0;
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xAxis);
            int y = (int)bounds.min(yAxis);
            int w = (int)bounds.dimension(xAxis);
            int h = (int)bounds.dimension(yAxis);
            int rgbChannels = 1;
            if (meta.get(imageIndex).isMultichannel()) {
                int cIndex = meta.get(imageIndex).getAxisIndex(Axes.CHANNEL);
                rgbChannels = (int)bounds.dimension(cIndex);
            }
            int sizeX = (int)meta.get(imageIndex).getAxisLength(Axes.X);
            int pixelType = ((Metadata)this.getMetadata()).get(imageIndex).getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            int planeSize = (int)(meta.get(0).getSize() / meta.get(0).getPlaneCount());
            this.pixels.seek(this.pixelOffset + planeIndex * (long)planeSize);
            if (SCIFIOMetadataTools.wholePlane(imageIndex, meta, bounds) && (interleaved || rgbChannels == 1)) {
                this.pixels.write(plane.getBytes());
            } else {
                this.pixels.skipBytes(bytesPerPixel * rgbChannels * sizeX * y);
                for (int row = 0; row < h; ++row) {
                    ByteArrayOutputStream strip = new ByteArrayOutputStream();
                    for (int col = 0; col < w; ++col) {
                        for (int c = 0; c < rgbChannels; ++c) {
                            int index = interleaved ? rgbChannels * (row * w + col) + c : w * (c * h + row) + col;
                            strip.write(plane.getBytes(), index * bytesPerPixel, bytesPerPixel);
                        }
                    }
                    this.pixels.skipBytes(bytesPerPixel * rgbChannels * x);
                    this.pixels.write(strip.toByteArray());
                    this.pixels.skipBytes(bytesPerPixel * rgbChannels * (sizeX - w - x));
                }
            }
            this.lastPlane = planeIndex;
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{0, 1, 2, 3, 4, 5, 6};
        }

        public void close(int imageIndex) throws IOException {
            super.close();
            this.pixelOffset = 0L;
            this.lastPlane = -1L;
            this.dimensionOffset = 0L;
            this.dimensionLength = 0;
            if (this.pixels != null) {
                this.pixels.close();
            }
            this.pixels = null;
        }

        @Override
        public void setDest(DataHandle<Location> out, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            String currentId = ((Location)out.get()).getName();
            if (FormatTools.checkSuffix(currentId, "ics")) {
                ((Metadata)this.getMetadata()).setIcsLocation((Location)out.get());
            } else {
                ((Metadata)this.getMetadata()).setIdsLocation((Location)out.get());
            }
            super.setDest(out, imageIndex, config);
            if (out.length() <= 0L) {
                out.writeBytes("\t\n");
                if (FormatTools.checkSuffix(currentId, "ids")) {
                    out.writeBytes("ics_version\t1.0\n");
                } else {
                    out.writeBytes("ics_version\t2.0\n");
                }
                out.writeBytes("filename\t" + currentId + "\n");
                out.writeBytes("layout\tparameters\t6\n");
                Metadata meta = (Metadata)this.getMetadata();
                int pixelType = meta.get(imageIndex).getPixelType();
                this.dimensionOffset = out.offset();
                int[] sizes = this.overwriteDimensions(meta, imageIndex);
                this.dimensionLength = (int)(out.offset() - this.dimensionOffset);
                if (this.getValidBits() != 0) {
                    out.writeBytes("layout\tsignificant_bits\t" + this.getValidBits() + "\n");
                }
                boolean signed = FormatTools.isSigned(pixelType);
                boolean littleEndian = meta.get(imageIndex).isLittleEndian();
                out.writeBytes("representation\tformat\t" + (pixelType == 6 ? "real\n" : "integer\n"));
                out.writeBytes("representation\tsign\t" + (signed ? "signed\n" : "unsigned\n"));
                out.writeBytes("representation\tcompression\tuncompressed\n");
                out.writeBytes("representation\tbyte_order\t");
                for (int i = 0; i < sizes[0] / 8; ++i) {
                    if (littleEndian && (sizes[0] < 32 || pixelType == 6) || !littleEndian && sizes[0] >= 32 && pixelType != 6) {
                        out.writeBytes(i + 1 + "\t");
                        continue;
                    }
                    out.writeBytes(sizes[0] / 8 - i + "\t");
                }
                out.writeBytes("\nparameter\tscale\t1.000000\t");
                StringBuilder units = new StringBuilder();
                for (CalibratedAxis axis : meta.get(imageIndex).getAxes()) {
                    Double value = 1.0;
                    if (axis.type() == Axes.X) {
                        value = axis.averageScale(0.0, 1.0);
                    } else if (axis.type() == Axes.Y) {
                        value = axis.averageScale(0.0, 1.0);
                    } else if (axis.type() == Axes.Z) {
                        value = axis.averageScale(0.0, 1.0);
                    } else if (axis.type() == Axes.TIME) {
                        value = axis.averageScale(0.0, 1.0);
                    }
                    units.append(axis.unit() + "\t");
                    out.writeBytes(value + "\t");
                }
                out.writeBytes("\nparameter\tunits\tbits\t" + units.toString() + "\n");
                out.writeBytes("\nend\n");
                this.pixelOffset = out.offset();
            } else if (FormatTools.checkSuffix(currentId, "ics")) {
                try (DataHandle tmpin = (DataHandle)this.dataHandleService.create(out.get());){
                    tmpin.findString(new String[]{"\nend\n"});
                    this.pixelOffset = tmpin.offset();
                }
            }
            if (FormatTools.checkSuffix(currentId, "ids")) {
                this.pixelOffset = 0L;
            }
            if (this.pixels == null) {
                this.pixels = (DataHandle)this.dataHandleService.create(out.get());
            }
        }

        private int[] overwriteDimensions(Metadata meta, int imageIndex) throws IOException {
            this.getHandle().seek(this.dimensionOffset);
            int pixelType = meta.get(imageIndex).getPixelType();
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            StringBuilder dimOrder = new StringBuilder();
            int[] sizes = new int[6];
            int nextSize = 0;
            sizes[nextSize++] = 8 * bytesPerPixel;
            if (meta.get(imageIndex).isMultichannel()) {
                dimOrder.append("ch\t");
                sizes[nextSize++] = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            }
            for (CalibratedAxis axis : meta.get(imageIndex).getAxes()) {
                if (axis.type() == Axes.CHANNEL) {
                    if (dimOrder.indexOf("ch") != -1) continue;
                    sizes[nextSize++] = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
                    dimOrder.append("ch");
                } else {
                    sizes[nextSize++] = (int)meta.get(imageIndex).getAxisLength(axis.type());
                    dimOrder.append(String.valueOf(axis.type().getLabel().charAt(0)).toLowerCase());
                }
                dimOrder.append("\t");
            }
            this.getHandle().writeBytes("layout\torder\tbits\t" + dimOrder.toString() + "\n");
            this.getHandle().writeBytes("layout\tsizes\t");
            for (Object size : (Object)sizes) {
                this.getHandle().writeBytes((int)size + "\t");
            }
            while (this.getHandle().offset() - this.dimensionOffset < (long)(this.dimensionLength - 1)) {
                this.getHandle().writeBytes(" ");
            }
            this.getHandle().writeBytes("\n");
            return sizes;
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private DataHandleService dataHandleService;
        private long prevPlane;
        private boolean gzip;
        private GZIPInputStream gzipStream;
        private boolean invertY;
        private byte[] data;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Light Microscopy", "Fluorescence-Lifetime Imaging", "Unknown"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, ((byte[])plane.getData()).length, bounds);
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xAxis);
            int y = (int)bounds.min(yAxis);
            int w = (int)bounds.dimension(xAxis);
            int h = (int)bounds.dimension(yAxis);
            int bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
            int len = (int)FormatTools.getPlaneSize(this, imageIndex);
            int rowLen = (int)FormatTools.getPlaneSize(meta, w, 1, imageIndex);
            long[] coordinates = FormatTools.rasterToPosition(imageIndex, planeIndex, meta);
            long[] prevCoordinates = FormatTools.rasterToPosition(imageIndex, this.prevPlane, meta);
            if (!this.gzip) {
                this.getHandle().seek(((Metadata)this.getMetadata()).offset + planeIndex * (long)len);
            } else {
                long toSkip = (planeIndex - this.prevPlane - 1L) * (long)len;
                if (this.gzipStream == null || planeIndex <= this.prevPlane) {
                    DataHandle fis = null;
                    toSkip = planeIndex * (long)len;
                    if (((Metadata)this.getMetadata()).versionTwo) {
                        fis = (DataHandle)this.dataHandleService.create((Object)((Metadata)this.getMetadata()).icsLocation);
                        fis.skip(((Metadata)this.getMetadata()).offset);
                    } else {
                        fis = (DataHandle)this.dataHandleService.create((Object)((Metadata)this.getMetadata()).idsLocation);
                        toSkip += ((Metadata)this.getMetadata()).offset;
                    }
                    try {
                        this.gzipStream = new GZIPInputStream((InputStream)new DataHandleInputStream(fis));
                    }
                    catch (IOException e) {
                        this.gzip = false;
                        this.getHandle().seek(((Metadata)this.getMetadata()).offset + planeIndex * (long)len);
                        this.gzipStream = null;
                    }
                }
                if (this.gzipStream != null) {
                    while (toSkip > 0L) {
                        toSkip -= this.gzipStream.skip(toSkip);
                    }
                    this.data = new byte[(int)((long)len * (meta.storedRGB() ? meta.get(imageIndex).getAxisLength(Axes.CHANNEL) : 1L))];
                    for (int toRead = this.data.length; toRead > 0; toRead -= this.gzipStream.read(this.data, this.data.length - toRead, toRead)) {
                    }
                }
            }
            int sizeC = (int)(meta.getLifetime() ? 1L : meta.get(imageIndex).getAxisLength(Axes.CHANNEL));
            if (!((Metadata)this.getMetadata()).get(imageIndex).isMultichannel() && ((Metadata)this.getMetadata()).storedRGB()) {
                this.getHandle().seek(((Metadata)this.getMetadata()).offset + (long)len * FormatTools.positionToRaster(0, this, new long[]{coordinates[0], 0L, coordinates[2]}));
                if (!this.gzip && this.data == null) {
                    this.data = new byte[(int)((long)len * ((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL))];
                    this.getHandle().read(this.data);
                } else if (!(this.gzip || coordinates[0] == prevCoordinates[0] && coordinates[2] == prevCoordinates[2])) {
                    this.getHandle().read(this.data);
                }
                for (int row = y; row < h + y; ++row) {
                    for (int col = x; col < w + x; ++col) {
                        int src = (int)((long)bpp * (planeIndex % meta.get(imageIndex).getAxisLength(Axes.CHANNEL) + (long)sizeC * ((long)row * ((long)row * meta.get(imageIndex).getAxisLength(Axes.X) + (long)col))));
                        int dest = bpp * ((row - y) * w + (col - x));
                        System.arraycopy(this.data, src, plane.getBytes(), dest, bpp);
                    }
                }
            } else if (this.gzip) {
                try (DataHandle bytes = (DataHandle)this.dataHandleService.create((Object)new BytesLocation(this.data));){
                    this.readPlane((DataHandle<Location>)bytes, imageIndex, bounds, plane);
                }
            } else {
                this.readPlane(this.getHandle(), imageIndex, bounds, plane);
            }
            if (this.invertY) {
                byte[] row = new byte[rowLen];
                for (int r = 0; r < h / 2; ++r) {
                    int topOffset = r * rowLen;
                    int bottomOffset = (h - r - 1) * rowLen;
                    System.arraycopy(plane.getBytes(), topOffset, row, 0, rowLen);
                    System.arraycopy(plane.getBytes(), bottomOffset, plane.getBytes(), topOffset, rowLen);
                    System.arraycopy(row, 0, plane.getBytes(), bottomOffset, rowLen);
                }
            }
            this.prevPlane = planeIndex;
            return plane;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.data = null;
                this.gzip = false;
                this.invertY = false;
                this.prevPlane = 0L;
                if (this.gzipStream != null) {
                    this.gzipStream.close();
                }
                this.gzipStream = null;
            }
        }

        @Override
        public void setMetadata(Metadata meta) throws IOException {
            super.setMetadata(meta);
            this.gzip = ((Metadata)this.getMetadata()).get("representation compression").equals("gzip");
            this.prevPlane = -1L;
            this.gzipStream = null;
            this.invertY = false;
            this.data = null;
        }

        @Override
        public void setSource(DataHandle<Location> stream, SCIFIOConfig config) throws IOException {
            if (!((Metadata)this.getMetadata()).versionTwo && !((Metadata)this.getMetadata()).getIdsLocation().equals(stream.get())) {
                stream.close();
                super.setSource((DataHandle<Location>)((DataHandle)this.dataHandleService.create((Object)((Metadata)this.getMetadata()).getIdsLocation())), config);
                return;
            }
            super.setSource(stream, config);
        }

        @Override
        public String[] getDomains() {
            FormatTools.assertStream(this.getHandle(), true, 0);
            String[] domain = new String[]{"Graphics"};
            if (((Metadata)this.getMetadata()).get(0).getAxisLength(SCIFIOAxes.LIFETIME) > 1L) {
                domain[0] = "Fluorescence-Lifetime Imaging";
            } else if (((Metadata)this.getMetadata()).hasInstrumentData) {
                domain[0] = "Light Microscopy";
            }
            return domain;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        private DataHandleService handles;

        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.findCompanion(stream, meta);
            DataHandle parseHandle = ((Location)stream.get()).equals(meta.idsLocation) ? this.handles.readBuffer(meta.icsLocation) : stream;
            parseHandle.seek(0L);
            String line = parseHandle.findString(ICSUtils.NL);
            while (line != null && !line.trim().equals("end") && parseHandle.offset() < parseHandle.length() - 1L) {
                line = line.trim().toLowerCase();
                String[] tokens = line.split("[ \t]");
                StringBuilder key = new StringBuilder();
                Map keyMap = ICSUtils.keys;
                boolean validKey = false;
                for (int q = 0; q < tokens.length; ++q) {
                    tokens[q] = tokens[q].trim();
                    if (tokens[q].length() == 0) continue;
                    Object o = keyMap.get(tokens[q]);
                    if (o == null) {
                        if (!validKey) break;
                        StringBuilder value = new StringBuilder(tokens[q++]);
                        while (q < tokens.length) {
                            value.append(" ");
                            value.append(tokens[q].trim());
                            ++q;
                        }
                        String k = key.toString().trim().replaceAll("\t", " ");
                        String v = value.toString().trim();
                        meta.getTable().put(k, v);
                        meta.keyValPairs.put(k.toLowerCase(), v);
                        continue;
                    }
                    keyMap = (Map)o;
                    if (keyMap.get("VALID_LEAF") != null) {
                        validKey = true;
                    }
                    key.append(tokens[q]);
                    key.append(" ");
                }
                line = parseHandle.findString(ICSUtils.NL);
            }
            Object icsVersion = meta.getTable().get("ics_version");
            if (icsVersion == null) {
                parseHandle.close();
                throw new FormatException("Cannot discern ICS version");
            }
            if ("1.0".equals(icsVersion)) {
                meta.setVersionTwo(false);
                Location idsLoc = meta.getIdsLocation();
                if (idsLoc == null) {
                    parseHandle.close();
                    throw new FormatException("Data file does not exist, should be located next to: " + ((Location)parseHandle.get()).toString());
                }
                parseHandle.close();
                this.getSource().close();
                this.updateSource(meta.getIdsLocation());
            } else if (icsVersion.equals("2.0")) {
                meta.setVersionTwo(true);
                meta.setIdsLocation(meta.getIcsLocation());
                meta.setSource((DataHandle<Location>)stream);
            } else {
                stream.close();
                parseHandle.close();
                throw new FormatException("Unsupported ICS version: " + icsVersion);
            }
            meta.offset = this.getSource().offset();
            this.getSource().seek(0L);
            meta.hasInstrumentData = this.nullKeyCheck(new String[]{"history cube emm nm", "history cube exc nm", "history objective NA", "history stage xyzum", "history objective magnification", "history objective mag", "history objective WorkingDistance", "history objective type", "history objective", "history objective immersion"});
        }

        private boolean nullKeyCheck(String[] testKeys) {
            for (String key : testKeys) {
                if (((Metadata)this.getMetadata()).get(key) == null) continue;
                return true;
            }
            return false;
        }

        private void findCompanion(DataHandle<Location> stream, Metadata meta) throws FormatException, IOException {
            BrowsableLocation idsLocation;
            BrowsableLocation icsLocation;
            String ext;
            String idsId = ((Location)stream.get()).getName();
            String icsId = idsId;
            if ("".equals(icsId) || !(stream.get() instanceof BrowsableLocation)) {
                return;
            }
            int dot = icsId.lastIndexOf(46);
            String string = ext = dot < 0 ? "" : icsId.substring(dot + 1).toLowerCase();
            if ("ics".equals(ext)) {
                char[] c = idsId.toCharArray();
                int n = c.length - 2;
                c[n] = (char)(c[n] + '\u0001');
                idsId = new String(c);
                icsLocation = (BrowsableLocation)stream.get();
                idsLocation = icsLocation.sibling(idsId);
            } else if ("ids".equals(ext)) {
                char[] c = icsId.toCharArray();
                int n = c.length - 2;
                c[n] = (char)(c[n] - '\u0001');
                icsId = new String(c);
                idsLocation = (BrowsableLocation)stream.get();
                icsLocation = idsLocation.sibling(icsId);
            } else {
                throw new FormatException("Companion file not found");
            }
            meta.setIcsLocation((Location)icsLocation);
            meta.setIdsLocation((Location)idsLocation);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private static final String MICRO_TIME = "micro-time";
        private static final String DEFAULT_LENGTH_UNIT = "um";
        private static final String DEFAULT_TIME_UNIT = "s";
        private static final String DEFAULT_UNKNOWN_UNIT = "unkown";
        private static final Double DEFAULT_AXIS_SCALE = 1.0;
        private boolean versionTwo = false;
        private long offset = -1L;
        private boolean hasInstrumentData = false;
        private boolean storedRGB;
        private final String icsId = "";
        private final String idsId = "";
        private Map<String, String> keyValPairs = new HashMap<String, String>();
        private Location icsLocation;
        private Location idsLocation;

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata imageMeta = this.get(0);
            int[] axisSizes = this.getAxesSizes();
            String[] axes = this.getAxes();
            imageMeta.setAxes(new CalibratedAxis[0], new long[0]);
            String[] parameterLabels = this.getParameterLabels();
            Double[] parameterScales = this.getParameterScales();
            String[] parameterUnits = this.getParameterUnits();
            Double[] historyExtents = this.getHistoryExtents();
            String[] historyLabels = this.getHistoryLabels();
            String[] historyUnits = this.getHistoryUnits();
            boolean lifetime = this.getLifetime();
            int bitsPerPixel = 0;
            int nVirtualAxis = 0;
            block14: for (int n = 0; n < axes.length; ++n) {
                String paramUnit;
                String defaultUnit;
                AxisType axisType;
                String axis;
                switch (axis = axes[n].toLowerCase()) {
                    case "bits": {
                        bitsPerPixel = axisSizes[n];
                        while (bitsPerPixel % 8 != 0) {
                            ++bitsPerPixel;
                        }
                        if (bitsPerPixel == 24 || bitsPerPixel == 48) {
                            bitsPerPixel /= 3;
                        }
                        ++nVirtualAxis;
                        continue block14;
                    }
                    case "x": 
                    case "y": 
                    case "z": {
                        String actualAxis;
                        String string = actualAxis = historyLabels == null ? axis : historyLabels[n - nVirtualAxis];
                        if (!actualAxis.equals("t")) {
                            axisType = Axes.get((String)actualAxis.toUpperCase());
                            defaultUnit = DEFAULT_LENGTH_UNIT;
                            break;
                        }
                        axisType = Axes.TIME;
                        defaultUnit = DEFAULT_TIME_UNIT;
                        break;
                    }
                    case "t": {
                        axisType = Axes.TIME;
                        defaultUnit = DEFAULT_TIME_UNIT;
                        break;
                    }
                    default: {
                        axisType = axis.startsWith("c") ? Axes.CHANNEL : (axis.startsWith("p") ? SCIFIOAxes.PHASE : (axis.startsWith("f") ? SCIFIOAxes.FREQUENCY : Axes.unknown()));
                        defaultUnit = DEFAULT_UNKNOWN_UNIT;
                    }
                }
                if (axisType.equals(Axes.TIME) && (MICRO_TIME.equals(parameterLabels[n]) || lifetime)) {
                    axisType = SCIFIOAxes.LIFETIME;
                }
                String unit = null;
                Double scale = null;
                String string = paramUnit = parameterUnits == null || n >= parameterUnits.length ? null : parameterUnits[n].toLowerCase();
                if (paramUnit != null && !paramUnit.equals("undefined")) {
                    unit = paramUnit;
                    Double d = scale = parameterScales == null ? null : parameterScales[n];
                }
                if (unit == null || scale == null) {
                    if (historyUnits != null && historyUnits[n - nVirtualAxis] != null) {
                        unit = historyUnits[n - nVirtualAxis].toLowerCase();
                    }
                    if (historyExtents != null && historyExtents[n - nVirtualAxis] != null) {
                        scale = historyExtents[n - nVirtualAxis] / (double)axisSizes[n];
                    }
                }
                if (unit == null || scale == null) {
                    unit = defaultUnit;
                    if (historyExtents != null && historyExtents[n - nVirtualAxis] != null) {
                        scale = historyExtents[n - nVirtualAxis] / (double)axisSizes[n];
                    }
                }
                if (unit == null || scale == null) {
                    unit = defaultUnit;
                    scale = DEFAULT_AXIS_SCALE;
                }
                CalibratedAxis newAxis = FormatTools.createAxis(axisType);
                FormatTools.calibrate(newAxis, scale, 0.0, unit);
                imageMeta.addAxis(newAxis, (long)axisSizes[n]);
            }
            if (this.getBitsPerPixel() != null) {
                bitsPerPixel = this.getBitsPerPixel();
            }
            imageMeta.setBitsPerPixel(bitsPerPixel);
            if (imageMeta.isMultichannel() && this.getEMWaves() != null && (long)this.getEMWaves().length == imageMeta.getAxisLength(Axes.CHANNEL)) {
                imageMeta.setAxisLength(Axes.CHANNEL, 1L);
                this.setStoredRGB(true);
            }
            imageMeta.setIndexed(false);
            imageMeta.setFalseColor(false);
            imageMeta.setMetadataComplete(true);
            imageMeta.setLittleEndian(true);
            String byteOrder = this.getByteOrder();
            String rFormat = this.getRepFormat();
            if (byteOrder != null) {
                String firstByte = byteOrder.split(" ")[0];
                int first = Integer.parseInt(firstByte);
                boolean little = rFormat.equals("real") ? first == 1 : first != 1;
                imageMeta.setLittleEndian(little);
            }
            int bytes = bitsPerPixel / 8;
            if (bitsPerPixel < 32) {
                imageMeta.setLittleEndian(!this.get(0).isLittleEndian());
            }
            boolean floatingPt = rFormat.equals("real");
            boolean signed = this.isSigned();
            try {
                imageMeta.setPixelType(FormatTools.pixelTypeFromBytes(bytes, signed, floatingPt));
            }
            catch (FormatException e) {
                this.log().error((Object)("Could not get pixel type from bytes: " + bytes), (Throwable)e);
            }
        }

        private boolean noMicroTime(String[] labels) {
            for (String s : labels) {
                if (s == null || !s.equals(MICRO_TIME)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.keyValPairs = new HashMap<String, String>();
            }
        }

        public boolean storedRGB() {
            return this.storedRGB;
        }

        public void setStoredRGB(boolean rgb) {
            this.storedRGB = rgb;
        }

        public String get(String key) {
            return this.keyValPairs.get(key);
        }

        public void setIcsLocation(Location icsLocation) {
            this.icsLocation = icsLocation;
        }

        public void setIdsLocation(Location idsLocation) {
            this.idsLocation = idsLocation;
        }

        public Location getIcsLocation() {
            return this.icsLocation;
        }

        public Location getIdsLocation() {
            return this.idsLocation;
        }

        public boolean hasInstrumentData() {
            return this.hasInstrumentData;
        }

        public void setHasInstrumentData(boolean hasInstrumentData) {
            this.hasInstrumentData = hasInstrumentData;
        }

        public boolean isVersionTwo() {
            return this.versionTwo;
        }

        public void setVersionTwo(boolean versionTwo) {
            this.versionTwo = versionTwo;
        }

        public void setKeyValPairs(Map<String, String> keyValPairs) {
            this.keyValPairs = keyValPairs;
        }

        public Map<String, String> getKeyValPairs() {
            return this.keyValPairs;
        }

        public void put(String key, String value) {
            if (value != null) {
                this.keyValPairs.put(key, value);
            }
        }

        public void putDate(String value) {
            this.put("history date", value);
        }

        public void putDescription(String value) {
            this.put("history other text", value);
        }

        public void putMicroscopeModel(String value) {
            this.put("history microscope", value);
        }

        public void putMicroscopeManufacturer(String value) {
            this.put("history manufacturer", value);
        }

        public void putExperimentType(String value) {
            this.put("history type", value);
        }

        public void putLifetime(boolean lifetime) {
            if (lifetime) {
                this.put("history type", "time resolved");
            }
        }

        public void putPixelSizes(Double[] pixelSizes) {
            this.put("parameter scale", this.merge(pixelSizes));
        }

        public void putUnits(String[] units) {
            this.put("parameter units", this.merge(units));
        }

        public void putAxes(String[] axes) {
            this.put("layout order", this.merge(axes));
        }

        public void putAxesSizes(double[] axesSizes) {
            this.put("layout sizes", this.mergePrimitiveDoubles(axesSizes));
        }

        public void putPhysicalPixelSizes(double[] physSizes) {
            this.put("history extents", this.mergePrimitiveDoubles(physSizes));
        }

        public void putTimestamps(Double[] timeStamp) {
            this.put("parameter t", this.merge(timeStamp));
        }

        public void putChannelNames(Map<Integer, String> cNames) {
            this.put("parameter ch", this.merge(cNames.values()));
        }

        public void putPinholes(Map<Integer, Double> pins) {
            this.put("sensor s_params pinholeradius", this.merge(pins.values()));
        }

        public void putEMWaves(Integer[] emWaves) {
            this.put("sensor s_params lambdaem", this.merge(emWaves));
        }

        public void putEMSingleton(Integer[] em) {
            this.put("history cube emm nm", this.merge(em));
        }

        public void putEXWaves(Integer[] exWaves) {
            this.put("sensor s_params LambdaEx", this.merge(exWaves));
        }

        public void putEXSingleton(Integer[] ex) {
            this.put("history cube exc nm", this.merge(ex));
        }

        public void putWavelengths(Map<Integer, Integer> waves) {
            this.put("history wavelength*", this.merge(waves.values()));
        }

        public void putByteOrder(String byteOrder) {
            this.put("representation byte_order", byteOrder);
        }

        public void putRepFormat(String repFormat) {
            this.put("representation format", repFormat);
        }

        public void putCompression(String cmp) {
            this.put("representation compression", cmp);
        }

        public void putSigned(boolean signed) {
            this.put("representation sign", String.valueOf(signed));
        }

        public void putLaserManufacturer(String laserMan) {
            this.put("history laser manufacturer", laserMan);
        }

        public void putLaserModel(String laserMod) {
            this.put("history laser model", laserMod);
        }

        public void putLaserRepetitionRate(Double laserRep) {
            this.put("history laser rep rate", laserRep.toString());
        }

        public void putLaserPower(Double laserPower) {
            this.put("history laser power", laserPower.toString());
        }

        public void putDichroicModel(String diModel) {
            this.put("history filterset dichroic name", diModel);
        }

        public void putExcitationModel(String exModel) {
            this.put("history filterset exc name", exModel);
        }

        public void putEmissionModel(String emModel) {
            this.put("history filterset emm name", emModel);
        }

        public void putFilterSetModel(String fltrModel) {
            this.put("history filterset", fltrModel);
        }

        public void putObjectiveModel(String objModel) {
            this.put("history objective type", objModel);
        }

        public void putImmersion(String immersion) {
            this.put("history objective immersion", immersion);
        }

        public void putLensNA(Double lensNA) {
            this.put("history objective na", lensNA.toString());
        }

        public void putWorkingDistance(Double wd) {
            this.put("history objective workingdistance", wd.toString());
        }

        public void putMagnification(Double mag) {
            this.put("history objective magnification", mag.toString());
        }

        public void putDetectorManufacturer(String detMan) {
            this.put("history camera manufacturer", detMan);
        }

        public void putDetectorModel(String detModel) {
            this.put("history camera model", detModel);
        }

        public void putBitsPerPixel(Integer bpp) {
            this.put("layout significant_bits", bpp.toString());
        }

        public void putGains(Map<Integer, Double> gains) {
            this.put("history gain", this.merge(gains.values()));
        }

        public void putAuthorLastName(String lastName) {
            this.put("history author", lastName);
        }

        public void putStagePositions(Double[] positions) {
            this.put("history stage_xyzum", this.merge(positions));
        }

        public void putStageX(Double stageX) {
            this.put("history stage positionx", stageX.toString());
        }

        public void putStageY(Double stageY) {
            this.put("history stage positiony", stageY.toString());
        }

        public void putStageZ(Double stageZ) {
            this.put("history stage positionz", stageZ.toString());
        }

        public void putExposureTime(Double expTime) {
            this.put("history exposure", expTime.toString());
        }

        public String getDate() {
            String date = null;
            String[] kv = this.findValueForKey("history date", "history created on", "history creation date");
            if (kv != null) {
                if (kv[0].equalsIgnoreCase("history date") || kv[0].equalsIgnoreCase("history created on")) {
                    if (kv[1].indexOf(32) > 0) {
                        date = kv[1].substring(0, kv[1].lastIndexOf(32));
                    }
                } else if (kv[0].equalsIgnoreCase("history creation date")) {
                    date = kv[1];
                }
            }
            if (date != null) {
                date = DateTools.formatDate(date, ICSUtils.DATE_FORMATS);
            }
            return date;
        }

        public String getDescription() {
            return this.findStringValueForKey("history other text");
        }

        public String getMicroscopeModel() {
            return this.findStringValueForKey("history microscope");
        }

        public String getMicroscopeManufacturer() {
            return this.findStringValueForKey("history manufacturer");
        }

        public boolean getLifetime() {
            String[] kv = this.findValueForKey("history type");
            boolean lifetime = false;
            if (kv != null && (kv[1].equalsIgnoreCase("time resolved") || kv[1].equalsIgnoreCase("FluorescenceLifetime"))) {
                lifetime = true;
            }
            return lifetime;
        }

        public String[] getParameterLabels() {
            String pLabels = this.findStringValueForKey("parameter labels");
            if (pLabels == null) {
                return new String[this.getAxes().length];
            }
            return pLabels.split(" ");
        }

        public String[] getHistoryLabels() {
            String[] kv = this.findValueForKey("history labels");
            return kv == null ? null : kv[1].split("\\s+");
        }

        public String getExperimentType() {
            return this.findStringValueForKey("history type");
        }

        public Double[] getParameterScales() {
            String[] kv = this.findValueForKey("parameter scale");
            return kv == null ? null : this.splitDoubles(kv[1]);
        }

        public String[] getParameterUnits() {
            String[] kv = this.findValueForKey("parameter units");
            return kv == null ? null : kv[1].split("\\s+");
        }

        public String[] getAxes() {
            String[] kv = this.findValueForKey("layout order");
            String[] axes = null;
            if (kv != null) {
                StringTokenizer t = new StringTokenizer(kv[1]);
                axes = new String[t.countTokens()];
                for (int n = 0; n < axes.length; ++n) {
                    axes[n] = t.nextToken().trim();
                }
            }
            return axes;
        }

        public int[] getAxesSizes() {
            String[] kv = this.findValueForKey("layout sizes");
            int[] sizes = null;
            if (kv != null) {
                String[] lengths = kv[1].split(" ");
                sizes = new int[lengths.length];
                for (int n = 0; n < sizes.length; ++n) {
                    try {
                        sizes[n] = Integer.parseInt(lengths[n].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse axis length", (Throwable)e);
                    }
                }
            }
            return sizes;
        }

        public Double[] getHistoryExtents() {
            String[] kv = this.findValueForKey("history extents");
            return kv == null ? null : this.splitDoubles(kv[1]);
        }

        public String[] getHistoryUnits() {
            String[] kv = this.findValueForKey("history units");
            return kv == null ? null : kv[1].split("\\s+");
        }

        public Double[] getTimestamps() {
            String[] kv = this.findValueForKey("parameter t");
            return kv == null ? null : this.splitDoubles(kv[1]);
        }

        public Map<Integer, String> getChannelNames() {
            String[] kv = this.findValueForKey("parameter ch");
            HashMap<Integer, String> channelNames = new HashMap<Integer, String>();
            if (kv != null) {
                String[] names = kv[1].split(" ");
                for (int n = 0; n < names.length; ++n) {
                    channelNames.put(new Integer(n), names[n].trim());
                }
            }
            return channelNames;
        }

        public void addStepChannel(Map<Integer, String> channelNames) {
            String[] kv = this.findValueIteration("history step", "name");
            if (kv != null) {
                channelNames.put(new Integer(kv[0].substring(12, kv[0].indexOf(32, 12))), kv[1]);
            }
        }

        public void addCubeChannel(Map<Integer, String> channelNames) {
            String[] kv = this.findValueForKey("history cube");
            if (kv != null) {
                channelNames.put(channelNames.size(), kv[1]);
            }
        }

        public Map<Integer, Double> getPinholes() {
            String[] kv = this.findValueForKey("sensor s_params pinholeradius");
            HashMap<Integer, Double> pinholes = new HashMap<Integer, Double>();
            if (kv != null) {
                String[] pins = kv[1].split(" ");
                int channel = 0;
                for (String pin : pins) {
                    if (pin.trim().equals("")) continue;
                    try {
                        pinholes.put(channel++, new Double(pin));
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse pinhole", (Throwable)e);
                    }
                }
            }
            return pinholes;
        }

        public Integer[] getEMWaves() {
            String[] kv = this.findValueForKey("sensor s_params lambdaem");
            Integer[] emWaves = null;
            if (kv != null) {
                String[] waves = kv[1].split(" ");
                emWaves = new Integer[waves.length];
                for (int n = 0; n < emWaves.length; ++n) {
                    try {
                        emWaves[n] = new Integer((int)Double.parseDouble(waves[n]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse emission wavelength", (Throwable)e);
                    }
                }
            }
            return emWaves;
        }

        public Integer[] getEMSingleton() {
            String[] kv = this.findValueForKey("history cube emm nm");
            Integer[] emWaves = null;
            if (kv != null) {
                emWaves = new Integer[]{new Integer(kv[1].split(" ")[1].trim())};
            }
            return emWaves;
        }

        public Integer[] getEXWaves() {
            String[] kv = this.findValueForKey("sensor s_params lambdaex");
            Integer[] exWaves = null;
            if (kv != null) {
                String[] waves = kv[1].split(" ");
                exWaves = new Integer[waves.length];
                for (int n = 0; n < exWaves.length; ++n) {
                    try {
                        exWaves[n] = new Integer((int)Double.parseDouble(waves[n]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse excitation wavelength", (Throwable)e);
                    }
                }
            }
            return exWaves;
        }

        public Integer[] getEXSingleton() {
            String[] kv = this.findValueForKey("history cube exc nm");
            Integer[] exWaves = null;
            if (kv != null) {
                exWaves = new Integer[]{new Integer(kv[1].split(" ")[1].trim())};
            }
            return exWaves;
        }

        public Map<Integer, Integer> getWavelengths() {
            String[] kv = this.findValueForKey("history wavelength*");
            HashMap<Integer, Integer> wavelengths = new HashMap<Integer, Integer>();
            if (kv != null) {
                String[] waves = kv[1].split(" ");
                for (int n = 0; n < waves.length; ++n) {
                    wavelengths.put(n, Integer.parseInt(waves[n]));
                }
            }
            return wavelengths;
        }

        public void addLaserWavelength(Map<Integer, Integer> wavelengths) {
            String[] kv = this.findValueIteration("history laser", "wavelength");
            if (kv != null) {
                int laser = Integer.parseInt(kv[0].substring(13, kv[0].indexOf(32, 13))) - 1;
                kv[1] = kv[1].replaceAll("nm", "").trim();
                try {
                    wavelengths.put(new Integer(laser), new Integer(kv[1]));
                }
                catch (NumberFormatException e) {
                    this.log().debug((Object)"Could not parse wavelength", (Throwable)e);
                }
            }
        }

        public String getByteOrder() {
            return this.findStringValueForKey("representation byte_order");
        }

        public String getRepFormat() {
            return this.findStringValueForKey("representation format");
        }

        public String getCompression() {
            return this.findStringValueForKey("representation compression");
        }

        public boolean isSigned() {
            String signed = this.findStringValueForKey("representation sign");
            return signed != null && signed.equals("signed");
        }

        public String getLaserManufacturer() {
            return this.findStringValueForKey("history laser manufacturer");
        }

        public String getLaserModel() {
            return this.findStringValueForKey("history laser model");
        }

        public Double getLaserRepetitionRate() {
            return this.findDoubleValueForKey("history laser rep rate");
        }

        public Double getLaserPower() {
            return this.findDoubleValueForKey("history laser power");
        }

        public String getDichroicModel() {
            return this.findStringValueForKey("history filterset dichroic name");
        }

        public String getExcitationModel() {
            return this.findStringValueForKey("history filterset exc name");
        }

        public String getEmissionModel() {
            return this.findStringValueForKey("history filterset emm name");
        }

        public String getFilterSetModel() {
            return this.findStringValueForKey("history filterset");
        }

        public String getObjectiveModel() {
            return this.findStringValueForKey("history objective type", "history objective");
        }

        public String getImmersion() {
            return this.findStringValueForKey("history objective immersion");
        }

        public Double getLensNA() {
            return this.findDoubleValueForKey("history objective na");
        }

        public Double getWorkingDistance() {
            return this.findDoubleValueForKey("history objective workingdistance");
        }

        public Double getMagnification() {
            return this.findDoubleValueForKey("history objective magnification", "history objective mag");
        }

        public String getDetectorManufacturer() {
            return this.findStringValueForKey("history camera manufacturer");
        }

        public String getDetectorModel() {
            return this.findStringValueForKey("history camera model");
        }

        public Integer getBitsPerPixel() {
            return this.findIntValueForKey("layout significant_bits");
        }

        public Map<Integer, Double> getGains() {
            String[] kv = this.findValueForKey("history gain");
            HashMap<Integer, Double> gains = new HashMap<Integer, Double>();
            if (kv != null) {
                Integer n = new Integer(0);
                try {
                    n = new Integer(kv[0].substring(12).trim());
                    n = new Integer(n - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                gains.put(n, new Double(kv[1]));
            }
            return gains;
        }

        public String getAuthorLastName() {
            return this.findStringValueForKey("history author", "history experimenter");
        }

        public Double[] getStagePositions() {
            String[] kv = this.findValueForKey("history stage_xyzum");
            Double[] stagePos = null;
            if (kv != null) {
                String[] positions = kv[1].split(" ");
                stagePos = new Double[positions.length];
                for (int n = 0; n < stagePos.length; ++n) {
                    try {
                        stagePos[n] = new Double(positions[n]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.log().debug((Object)"Could not parse stage position", (Throwable)e);
                    }
                }
            }
            return stagePos;
        }

        public Double getStageX() {
            return this.findDoubleValueForKey("history stage positionx");
        }

        public Double getStageY() {
            return this.findDoubleValueForKey("history stage positiony");
        }

        public Double getStageZ() {
            return this.findDoubleValueForKey("history stage positionz");
        }

        public Double getExposureTime() {
            String expTime;
            String[] kv = this.findValueForKey("history exposure");
            Double exposureTime = null;
            if (kv != null && (expTime = kv[1]).contains(" ")) {
                exposureTime = new Double(expTime.indexOf(32));
            }
            return exposureTime;
        }

        String[] findKeyValue(String[] tokens, String[][] regexesArray) {
            String[] keyValue = this.findKeyValueForCategory(tokens, regexesArray);
            if (null == keyValue) {
                keyValue = this.findKeyValueOther(tokens, ICSUtils.OTHER_KEYS);
            }
            if (null == keyValue) {
                String key = tokens[0];
                String value = this.concatenateTokens(tokens, 1, tokens.length);
                keyValue = new String[]{key, value};
            }
            return keyValue;
        }

        private String concatenateTokens(String[] tokens, int start, int stop) {
            StringBuilder returnValue = new StringBuilder();
            for (int i = start; i < tokens.length && i < stop; ++i) {
                returnValue.append(tokens[i]);
                if (i >= stop - 1) continue;
                returnValue.append(' ');
            }
            return returnValue.toString();
        }

        private Double findDoubleValueForKey(String ... keys) {
            String[] kv = this.findValueForKey(keys);
            return kv == null ? null : new Double(kv[1]);
        }

        private Integer findIntValueForKey(String ... keys) {
            String[] kv = this.findValueForKey(keys);
            return kv == null ? null : new Integer(kv[1]);
        }

        private String findStringValueForKey(String ... keys) {
            String[] kv = this.findValueForKey(keys);
            return kv == null ? null : kv[1];
        }

        private String[] findValueForKey(String ... keys) {
            for (String key : keys) {
                String value = this.keyValPairs.get(key);
                if (value == null) continue;
                return new String[]{key, value};
            }
            return null;
        }

        private String[] findValueIteration(String starts, String ends) {
            for (String key : this.keyValPairs.keySet()) {
                if (starts != null && !key.startsWith(starts) || ends != null && !key.endsWith(ends)) continue;
                return new String[]{key, this.keyValPairs.get(key)};
            }
            return null;
        }

        private String[] findKeyValueForCategory(String[] tokens, String[][] regexesArray) {
            String[] keyValue = null;
            for (String[] regexes : regexesArray) {
                if (!this.compareTokens(tokens, 1, regexes, 0)) continue;
                int splitIndex = 1 + regexes.length;
                String key = this.concatenateTokens(tokens, 0, splitIndex);
                String value = this.concatenateTokens(tokens, splitIndex, tokens.length);
                keyValue = new String[]{key, value};
                break;
            }
            return keyValue;
        }

        private String[] findKeyValueOther(String[] tokens, String[][] regexesArray) {
            String[] keyValue = null;
            for (String[] regexes : regexesArray) {
                for (int i = 1; i < tokens.length - regexes.length; ++i) {
                    if (!tokens[i].toLowerCase().matches(regexes[0]) || 1 != regexes.length && !this.compareTokens(tokens, i + 1, regexes, 1)) continue;
                    int splitIndex = i + regexes.length;
                    String key = this.concatenateTokens(tokens, 0, splitIndex);
                    String value = this.concatenateTokens(tokens, splitIndex, tokens.length);
                    keyValue = new String[]{key, value};
                    break;
                }
                if (null != keyValue) break;
            }
            return keyValue;
        }

        private boolean compareTokens(String[] tokens, int tokenIndex, String[] regexes, int regexesIndex) {
            boolean returnValue = true;
            int i = tokenIndex;
            for (int j = regexesIndex; j < regexes.length; ++j) {
                if (i >= tokens.length || !tokens[i].toLowerCase().matches(regexes[j])) {
                    returnValue = false;
                    break;
                }
                ++i;
            }
            return returnValue;
        }

        private Double[] splitDoubles(String v) {
            StringTokenizer t = new StringTokenizer(v);
            Double[] values = new Double[t.countTokens()];
            for (int n = 0; n < values.length; ++n) {
                String token = t.nextToken().trim();
                try {
                    values[n] = new Double(token);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.log().debug((Object)("Could not parse double value '" + token + "'"), (Throwable)e);
                }
            }
            return values;
        }

        private String mergePrimitiveDoubles(double ... doubles) {
            Double[] d = new Double[doubles.length];
            for (int i = 0; i < doubles.length; ++i) {
                d[i] = doubles[i];
            }
            return this.merge(d);
        }

        private <T> String merge(Collection<T> collection) {
            Object[] array = collection.toArray();
            return this.merge(array);
        }

        private <T> String merge(T ... values) {
            StringBuilder b = new StringBuilder();
            for (T v : values) {
                b.append(v.toString() + " ");
            }
            return b.toString();
        }
    }
}

