/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="PCX")
public class PCXFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"pcx"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            plane.setColorTable(meta.getColorTable(imageIndex, planeIndex));
            byte[] buf = (byte[])plane.getData();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, bounds);
            this.getHandle().seek(meta.getOffset());
            byte[] b = new byte[meta.getBytesPerLine() * (int)meta.get(imageIndex).getAxisLength(Axes.Y) * meta.getnColorPlanes()];
            int pt = 0;
            block0: while (pt < b.length) {
                int val = this.getHandle().read() & 0xFF;
                if ((val & 0xC0) >> 6 == 3) {
                    int len = val & 0x3F;
                    val = this.getHandle().read() & 0xFF;
                    for (int q = 0; q < len; ++q) {
                        b[pt++] = (byte)val;
                        if (pt % meta.getBytesPerLine() == 0) continue block0;
                    }
                    continue;
                }
                b[pt++] = (byte)(val & 0xFF);
            }
            int xIndex = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xIndex);
            int y = (int)bounds.min(yIndex);
            int w = (int)bounds.dimension(xIndex);
            int h = (int)bounds.dimension(yIndex);
            int src = y * meta.getnColorPlanes() * meta.getBytesPerLine();
            for (int row = 0; row < h; ++row) {
                int rowOffset = row * meta.getnColorPlanes() * meta.getBytesPerLine();
                for (int c = 0; c < meta.getnColorPlanes(); ++c) {
                    System.arraycopy(b, src + rowOffset + x, buf, c * w * h + row * w, w);
                    rowOffset += meta.getBytesPerLine();
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.log().info((Object)"Reading file header");
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            iMeta.setLittleEndian(true);
            stream.setOrder(DataHandle.ByteOrder.LITTLE_ENDIAN);
            stream.seek(1L);
            int version = stream.read();
            stream.skipBytes(1);
            iMeta.setBitsPerPixel(stream.read());
            short xMin = stream.readShort();
            short yMin = stream.readShort();
            short xMax = stream.readShort();
            short yMax = stream.readShort();
            iMeta.setAxisLength(Axes.X, (long)(xMax - xMin));
            iMeta.setAxisLength(Axes.Y, (long)(yMax - yMin));
            stream.skipBytes(version == 5 ? 53 : 51);
            meta.setnColorPlanes(stream.read());
            meta.setBytesPerLine(stream.readShort());
            short paletteType = stream.readShort();
            meta.setOffset(stream.offset() + 58L);
            if (version == 5 && meta.getnColorPlanes() == 1) {
                stream.seek(stream.length() - 768L);
                byte[][] lut = new byte[3][256];
                for (int i = 0; i < lut[0].length; ++i) {
                    for (int j = 0; j < lut.length; ++j) {
                        lut[j][i] = stream.readByte();
                    }
                }
                meta.lut = new ColorTable8(lut);
                iMeta.setIndexed(true);
            }
            meta.getTable().put("Palette type", Integer.valueOf(paletteType));
        }
    }

    public static class Checker
    extends AbstractChecker {
        public static final byte PCX_MAGIC_BYTE = 10;

        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            boolean blockLen = true;
            if (!FormatTools.validStream(stream, 1, false)) {
                return false;
            }
            return stream.read() == 10;
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        private long offset;
        private int bytesPerLine;
        private int nColorPlanes;
        private ColorTable8 lut;

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public int getBytesPerLine() {
            return this.bytesPerLine;
        }

        public void setBytesPerLine(int bytesPerLine) {
            this.bytesPerLine = bytesPerLine;
        }

        public int getnColorPlanes() {
            return this.nColorPlanes;
        }

        public void setnColorPlanes(int nColorPlanes) {
            this.nColorPlanes = nColorPlanes;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisLength(Axes.CHANNEL, (long)this.nColorPlanes);
            iMeta.setPlanarAxisCount(iMeta.getAxisLength(Axes.CHANNEL) > 1L ? 3 : 2);
            iMeta.setPixelType(1);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.offset = 0L;
                this.bytesPerLine = 0;
                this.nColorPlanes = 0;
                this.lut = null;
            }
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            return this.lut;
        }
    }
}

