/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractTranslator;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Field;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.MetadataService;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.config.SCIFIOConfig;
import io.scif.io.location.TestImgLocation;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="Simulated data")
public class TestImgFormat
extends AbstractFormat {
    private static final long SEED = -889275714L;

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"scifiotestimg"};
    }

    public static class TestImgUtils {
        public static void createIndexMaps(int[][] indexToValue, int[][] valueToIndex) {
            TestImgUtils.sizeCheck(indexToValue, valueToIndex);
            TestImgUtils.createIndexValueMap(indexToValue);
            TestImgUtils.createInverseIndexMap(indexToValue, valueToIndex);
        }

        public static void createIndexValueMap(int[][] indexToValue) {
            for (int c = 0; c < indexToValue.length; ++c) {
                for (int index = 0; index < indexToValue[0].length; ++index) {
                    indexToValue[c][index] = index;
                }
                TestImgUtils.shuffle(c, indexToValue[c]);
            }
        }

        public static void createInverseIndexMap(int[][] indexToValue, int[][] valueToIndex) {
            TestImgUtils.sizeCheck(indexToValue, valueToIndex);
            for (int c = 0; c < indexToValue.length; ++c) {
                int index = 0;
                while (index < indexToValue[0].length) {
                    int value = indexToValue[c][index];
                    valueToIndex[c][value] = index++;
                }
            }
        }

        public static void shuffle(int c, int[] array) {
            Random r = new Random(-889275714L + (long)c);
            for (int i = array.length; i > 1; --i) {
                int j = r.nextInt(i);
                int tmp = array[j];
                array[j] = array[i - 1];
                array[i - 1] = tmp;
            }
        }

        private static void sizeCheck(int[][] array1, int[][] array2) {
            if (array1.length != array2.length || array1[0].length != array2[0].length) {
                throw new IllegalArgumentException("Arrays must be of the same size.");
            }
        }
    }

    @Plugin(type=Translator.class, priority=-100.0)
    public static class TestImgTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Parameter
        private DataHandleService dataHandleService;

        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            ImageMetadata iMeta = source.get(0);
            String name = dest.getDatasetName();
            String[] axes = new String[iMeta.getAxes().size()];
            long[] lengths = new long[axes.length];
            double[] scales = new double[axes.length];
            String[] units = new String[axes.length];
            int index = 0;
            for (CalibratedAxis axis : iMeta.getAxes()) {
                axes[index] = axis.type().getLabel();
                lengths[index] = iMeta.getAxisLength(axis);
                scales[index] = axis.averageScale(0.0, (double)lengths[index]);
                units[index] = axis.unit();
                ++index;
            }
            TestImgLocation.Builder b = new TestImgLocation.Builder();
            b.axes(axes);
            b.lengths(lengths);
            b.scales(scales);
            b.units(units);
            b.planarDims(iMeta.getPlanarAxisCount());
            b.interleavedDims(iMeta.getInterleavedAxisCount());
            b.thumbSizeX((int)iMeta.getThumbSizeX());
            b.thumbSizeY((int)iMeta.getThumbSizeX());
            b.pixelType(FormatTools.getPixelTypeString(iMeta.getPixelType()));
            b.falseColor(iMeta.isFalseColor());
            b.little(iMeta.isLittleEndian());
            b.metadataComplete(iMeta.isMetadataComplete());
            b.thumbnail(iMeta.isThumbnail());
            b.orderCertain(iMeta.isOrderCertain());
            b.images(source.size());
            if (iMeta.isIndexed()) {
                int lutLength = ((HasColorTable)((Object)source)).getColorTable(0, 0L).getComponentCount();
                b.indexed(iMeta.isIndexed());
                b.lutLength(lutLength);
            }
            try {
                dest.close();
                dest.setSource((DataHandle<Location>)((DataHandle)this.dataHandleService.create((Object)b.build())));
            }
            catch (IOException e) {
                this.log().debug((Object)("Failed to create RAIS: " + name), (Throwable)e);
            }
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[0];
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, ((byte[])plane.getData()).length, bounds);
            plane.setImageMetadata(meta.get(imageIndex));
            long[] pos = FormatTools.rasterToPosition(meta.get(imageIndex).getAxesLengthsNonPlanar(), planeIndex);
            long[] planarIndices = new long[bounds.numDimensions()];
            this.openPlaneHelper(imageIndex, planeIndex, meta, plane, bounds, pos, planarIndices, 0, -1L, -1L);
            return plane;
        }

        private void openPlaneHelper(int imageIndex, long planeIndex, Metadata meta, Plane plane, Interval bounds, long[] npIndices, long[] planeIndices, int planarPos, long xPos, long yPos) {
            if (planarPos < bounds.numDimensions()) {
                int i = 0;
                while ((long)i < bounds.dimension(planarPos)) {
                    if (planarPos == meta.get(imageIndex).getAxisIndex(Axes.X)) {
                        xPos = bounds.min(planarPos) + (long)i;
                    }
                    if (planarPos == meta.get(imageIndex).getAxisIndex(Axes.Y)) {
                        yPos = bounds.min(planarPos) + (long)i;
                    }
                    planeIndices[planarPos] = bounds.min(planarPos) + (long)i;
                    this.openPlaneHelper(imageIndex, planeIndex, meta, plane, bounds, npIndices, planeIndices, planarPos + 1, xPos, yPos);
                    ++i;
                }
            } else {
                long min;
                int pixelType = meta.get(imageIndex).getPixelType();
                int bpp = FormatTools.getBytesPerPixel(pixelType);
                boolean signed = FormatTools.isSigned(pixelType);
                boolean floating = FormatTools.isFloatingPoint(pixelType);
                boolean indexed = meta.get(imageIndex).isIndexed();
                boolean little = meta.get(imageIndex).isLittleEndian();
                int scaleFactor = meta.getScaleFactor();
                ColorTable lut = meta.getColorTable(imageIndex, planeIndex);
                int[][] valueToIndex = ((Metadata)this.getMetadata()).getValueToIndex();
                long l = min = signed ? (long)(-Math.pow(2.0, 8 * bpp - 1)) : 0L;
                if (floating) {
                    min = 0L;
                }
                int boxSize = 10;
                long pixel = min + xPos;
                boolean specialPixel = false;
                if (yPos < 10L) {
                    int grid = (int)(xPos / 10L);
                    specialPixel = true;
                    switch (grid) {
                        case 0: {
                            pixel = imageIndex;
                            break;
                        }
                        case 1: {
                            pixel = planeIndex;
                            break;
                        }
                        default: {
                            if ((grid -= 2) < npIndices.length) {
                                pixel = min + npIndices[grid];
                                break;
                            }
                            specialPixel = false;
                        }
                    }
                }
                if (indexed && lut != null) {
                    int modValue = lut.getLength();
                    plane.setColorTable(lut);
                    if (valueToIndex != null) {
                        pixel = valueToIndex[(int)planeIndex][(int)(pixel % (long)modValue)];
                    }
                }
                switch (pixelType) {
                    case 6: {
                        float floatPixel = specialPixel ? (float)pixel : (float)((long)scaleFactor * pixel);
                        pixel = Float.floatToIntBits(floatPixel);
                        break;
                    }
                    case 7: {
                        double doublePixel = specialPixel ? (double)pixel : (double)((long)scaleFactor * pixel);
                        pixel = Double.doubleToLongBits(doublePixel);
                        break;
                    }
                    default: {
                        if (specialPixel) break;
                        pixel = (long)scaleFactor * pixel;
                    }
                }
                int index = 0;
                for (int i = planeIndices.length - 1; i >= 0; --i) {
                    long partialIndex = planeIndices[i] - bounds.min(i);
                    for (int j = 0; j < i; ++j) {
                        partialIndex *= bounds.dimension(j);
                    }
                    index += (int)partialIndex;
                }
                Bytes.unpack((long)pixel, (byte[])plane.getBytes(), (int)(index *= bpp), (int)bpp, (boolean)little);
            }
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        private MetadataService metadataService;

        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            Map<String, Object> fakeMap = ((TestImgLocation)this.getSourceLocation()).getMetadataMap();
            this.metadataService.populate(meta, fakeMap);
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean isFormat(Location loc, SCIFIOConfig config) {
            return loc instanceof TestImgLocation;
        }

        @Override
        public boolean isFormat(Location loc) {
            return loc instanceof TestImgLocation;
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        @Field
        private String[] axes;
        @Field
        private long[] lengths;
        @Field
        private double[] scales;
        @Field
        private String[] units;
        @Field
        private int planarDims;
        @Field
        private int interleavedDims;
        @Field
        private int thumbSizeX;
        @Field
        private int thumbSizeY;
        @Field
        private String pixelType;
        @Field
        private boolean indexed;
        @Field
        private boolean falseColor;
        @Field
        private boolean little;
        @Field
        private boolean metadataComplete;
        @Field
        private boolean thumbnail;
        @Field
        private boolean orderCertain;
        @Field
        private int lutLength;
        @Field
        private int scaleFactor;
        @Field
        private int images;
        private ColorTable[][] luts;
        private int[][] valueToIndex;

        public int getScaleFactor() {
            return this.scaleFactor;
        }

        public ColorTable[][] getLuts() {
            return this.luts;
        }

        public void setLuts(ColorTable[][] luts) {
            this.luts = luts;
        }

        public int[][] getValueToIndex() {
            return this.valueToIndex;
        }

        public void setValueToIndex(int[][] valueToIndex) {
            this.valueToIndex = valueToIndex;
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            return this.luts == null ? null : this.luts[imageIndex][(int)planeIndex];
        }

        @Override
        public void populateImageMetadata() {
            int i;
            if (this.axes.length != this.lengths.length) {
                throw new IllegalStateException("FakeFormat id: " + this.getDatasetName() + " is not valid. Can not have a differing number of axis types and axis lengths.");
            }
            int pType = FormatTools.pixelTypeFromString(this.pixelType);
            int bpp = FormatTools.getBitsPerPixel(pType);
            CalibratedAxis[] calibratedAxes = new CalibratedAxis[this.axes.length];
            for (i = 0; i < calibratedAxes.length; ++i) {
                double scale = 1.0;
                String unit = "um";
                if (i < this.units.length) {
                    unit = this.units[i];
                }
                if (i < this.scales.length) {
                    scale = this.scales[i];
                }
                calibratedAxes[i] = new DefaultLinearAxis(Axes.get((String)this.axes[i]), unit, scale);
            }
            this.createImageMetadata(this.images);
            for (i = 0; i < this.images; ++i) {
                ImageMetadata imageMeta = this.get(i);
                imageMeta.setAxes(calibratedAxes, this.lengths);
                imageMeta.setPlanarAxisCount(this.planarDims);
                imageMeta.setInterleavedAxisCount(this.interleavedDims);
                imageMeta.setPixelType(pType);
                imageMeta.setThumbSizeX(this.thumbSizeX);
                imageMeta.setThumbSizeY(this.thumbSizeY);
                imageMeta.setIndexed(this.indexed);
                imageMeta.setFalseColor(this.falseColor);
                imageMeta.setLittleEndian(this.little);
                imageMeta.setMetadataComplete(this.metadataComplete);
                imageMeta.setThumbnail(this.thumbnail);
                imageMeta.setOrderCertain(this.orderCertain);
                imageMeta.setBitsPerPixel(bpp);
            }
            if (this.indexed) {
                int[][] indexToValue = null;
                int[][] valueToIndex = null;
                ColorTable[][] luts = null;
                if (pType == 1) {
                    int num = 256;
                    luts = new ColorTable8[this.images][];
                    for (int i2 = 0; i2 < this.images; ++i2) {
                        int planeCount = (int)this.get(i2).getPlaneCount();
                        luts[i2] = new ColorTable8[planeCount];
                        indexToValue = new int[planeCount][256];
                        valueToIndex = new int[planeCount][256];
                        TestImgUtils.createIndexValueMap(indexToValue);
                        for (int p = 0; p < planeCount; ++p) {
                            byte[][] lutBytes = new byte[this.lutLength][256];
                            for (int cmpIndex = 0; cmpIndex < this.lutLength; ++cmpIndex) {
                                for (int index = 0; index < 256; ++index) {
                                    lutBytes[cmpIndex][index] = (byte)indexToValue[p][index];
                                }
                            }
                            luts[i2][p] = new ColorTable8(lutBytes);
                        }
                    }
                } else if (pType == 3) {
                    int num = 65536;
                    luts = new ColorTable16[this.images][];
                    for (int i3 = 0; i3 < this.images; ++i3) {
                        int planeCount = (int)this.get(i3).getPlaneCount();
                        luts[i3] = new ColorTable16[planeCount];
                        indexToValue = new int[planeCount][65536];
                        valueToIndex = new int[planeCount][65536];
                        TestImgUtils.createIndexValueMap(indexToValue);
                        for (int p = 0; p < planeCount; ++p) {
                            short[][] lutShorts = new short[this.lutLength][65536];
                            for (int cmpIndex = 0; cmpIndex < this.lutLength; ++cmpIndex) {
                                for (int index = 0; index < 65536; ++index) {
                                    lutShorts[cmpIndex][index] = (short)indexToValue[p][index];
                                }
                            }
                            luts[i3][p] = new ColorTable16(lutShorts);
                        }
                    }
                }
                this.setLuts(luts);
                if (valueToIndex != null) {
                    TestImgUtils.createInverseIndexMap(indexToValue, valueToIndex);
                    this.setValueToIndex(valueToIndex);
                }
            }
        }
    }
}

