/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.ChannelFiller;
import io.scif.filters.MinMaxFilter;
import io.scif.filters.PlaneSeparator;
import io.scif.filters.ReaderFilter;
import io.scif.img.AbstractImgIOComponent;
import io.scif.img.DefaultImgFactoryHeuristic;
import io.scif.img.ImageRegion;
import io.scif.img.ImgFactoryHeuristic;
import io.scif.img.ImgIOException;
import io.scif.img.Range;
import io.scif.img.SCIFIOImgPlus;
import io.scif.img.cell.SCIFIOCellImgFactory;
import io.scif.img.converters.PlaneConverter;
import io.scif.img.converters.PlaneConverterService;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.Parameter;
import org.scijava.util.ListUtils;

public class ImgOpener
extends AbstractImgIOComponent {
    @Parameter
    private StatusService statusService;
    @Parameter
    private PlaneConverterService pcService;
    @Parameter
    private InitializeService initializeService;
    @Parameter
    private LocationService locationService;

    public ImgOpener() {
    }

    public ImgOpener(Context ctx) {
        super(ctx);
    }

    public List<SCIFIOImgPlus<?>> openImgs(String source) throws ImgIOException {
        return this.openImgs(this.resolve(source));
    }

    public <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, T type) throws ImgIOException {
        return this.openImgs(this.resolve(source), type);
    }

    public List<SCIFIOImgPlus<?>> openImgs(String source, SCIFIOConfig config) throws ImgIOException {
        return this.openImgs(this.resolve(source), config);
    }

    public <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, T type, SCIFIOConfig config) throws ImgIOException {
        return this.openImgs(this.resolve(source), type, config);
    }

    public <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory) throws ImgIOException {
        return this.openImgs(this.resolve(source), imgFactory);
    }

    public <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        return this.openImgs(this.resolve(source), imgFactory, config);
    }

    public List<SCIFIOImgPlus<?>> openImgs(Location source) throws ImgIOException {
        return this.openImgs(source, (SCIFIOConfig)null);
    }

    public <T> List<SCIFIOImgPlus<T>> openImgs(Location source, T type) throws ImgIOException {
        return this.openImgs(source, type, null);
    }

    public List<SCIFIOImgPlus<?>> openImgs(Location source, SCIFIOConfig config) throws ImgIOException {
        if (config == null) {
            config = new SCIFIOConfig(this.getContext());
        }
        Reader r = this.createReader(source, config);
        return this.openImgs(r, config);
    }

    public <T> List<SCIFIOImgPlus<T>> openImgs(Location source, T type, SCIFIOConfig config) throws ImgIOException {
        if (config == null) {
            config = new SCIFIOConfig(this.getContext()).imgOpenerSetComputeMinMax(true);
        }
        Reader r = this.createReader(source, config);
        return this.openImgs(r, type, config);
    }

    public <T> List<SCIFIOImgPlus<T>> openImgs(Location source, ImgFactory<T> imgFactory) throws ImgIOException {
        return this.openImgs(source, imgFactory, (SCIFIOConfig)null);
    }

    public <T> List<SCIFIOImgPlus<T>> openImgs(Location source, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        if (config == null) {
            config = new SCIFIOConfig(this.getContext()).imgOpenerSetComputeMinMax(true);
        }
        Reader r = this.createReader(source, config);
        return this.openImgs(r, imgFactory, config);
    }

    public List<SCIFIOImgPlus<?>> openImgs(Reader reader) throws ImgIOException {
        return this.openImgs(reader, null);
    }

    public List<SCIFIOImgPlus<?>> openImgs(Reader reader, SCIFIOConfig config) throws ImgIOException {
        return this.openImgs(reader, this.getType(reader), config);
    }

    public <T> List<SCIFIOImgPlus<T>> openImgs(Reader reader, T type, SCIFIOConfig config) throws ImgIOException {
        ImgFactory<T> imgFactory;
        if (config == null) {
            config = new SCIFIOConfig(this.getContext()).imgOpenerSetComputeMinMax(true);
        }
        ImgFactoryHeuristic heuristic = this.getHeuristic(config);
        try {
            imgFactory = heuristic.createFactory(reader.getMetadata(), config.imgOpenerGetImgModes(), type);
        }
        catch (IncompatibleTypeException e) {
            throw new ImgIOException(e);
        }
        return this.openImgs(reader, imgFactory, config);
    }

    public <T> List<SCIFIOImgPlus<T>> openImgs(Reader reader, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        if (!ReaderFilter.class.isAssignableFrom(reader.getClass())) {
            reader = new ReaderFilter(reader);
        }
        ArrayList<SCIFIOImgPlus<T>> imgPluses = new ArrayList<SCIFIOImgPlus<T>>();
        Range imageRange = null;
        if (config == null) {
            config = new SCIFIOConfig(this.getContext()).imgOpenerSetComputeMinMax(true);
        }
        imageRange = config.imgOpenerIsOpenAllImages() ? new Range("0-" + (reader.getMetadata().getImageCount() - 1)) : config.imgOpenerGetRange();
        for (Long imageIndex : imageRange) {
            long[] dimLengths = this.utils().getConstrainedLengths(reader.getMetadata(), this.i(imageIndex), config);
            if (SCIFIOCellImgFactory.class.isAssignableFrom(imgFactory.getClass())) {
                ((SCIFIOCellImgFactory)imgFactory).setReader(reader, this.i(imageIndex));
                ((SCIFIOCellImgFactory)imgFactory).setSubRegion(config.imgOpenerGetRegion());
            }
            Img img = imgFactory.create(dimLengths);
            SCIFIOImgPlus<T> imgPlus = this.makeImgPlus(img, reader, this.i(imageIndex));
            Location id = reader.getCurrentLocation();
            URI uri = id.getURI();
            imgPlus.setSource(uri == null ? null : uri.toString());
            imgPlus.initializeColorTables(this.i(reader.getPlaneCount(this.i(imageIndex))));
            if (config.imgOpenerIsComputeMinMax()) {
                long[] defaultMinMax = FormatTools.defaultMinMax(reader.getMetadata().get(this.i(imageIndex)));
                for (int c = 0; c < imgPlus.getCompositeChannelCount(); ++c) {
                    imgPlus.setChannelMinimum(c, defaultMinMax[0]);
                    imgPlus.setChannelMaximum(c, defaultMinMax[1]);
                }
            }
            Metadata meta = reader.getMetadata();
            imgPlus.setMetadata(meta);
            imgPlus.setImageMetadata(meta.get(this.i(imageIndex)));
            imgPlus.setROIsAndTablesProperties(meta, this.i(imageIndex));
            if (!SCIFIOCellImgFactory.class.isAssignableFrom(imgFactory.getClass())) {
                float startTime = System.currentTimeMillis();
                long planeCount = reader.getPlaneCount(this.i(imageIndex));
                try {
                    this.readPlanes(reader, this.i(imageIndex), imgPlus, config);
                }
                catch (FormatException | IOException e) {
                    throw new ImgIOException(e);
                }
                long endTime = System.currentTimeMillis();
                float time = ((float)endTime - startTime) / 1000.0f;
                this.statusService.showStatus(id + ": read " + planeCount + " planes in " + time + "s");
            }
            imgPluses.add(imgPlus);
        }
        if (SCIFIOCellImgFactory.class.isAssignableFrom(imgFactory.getClass())) {
            this.statusService.showStatus("Created CellImg for dynamic loading");
        } else {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new ImgIOException(e);
            }
        }
        return imgPluses;
    }

    private Type<?> getType(Reader r) {
        return this.utils().makeType(r.getMetadata().get(0).getPixelType());
    }

    private ImgFactoryHeuristic getHeuristic(SCIFIOConfig imgOptions) {
        ImgFactoryHeuristic heuristic = imgOptions.imgOpenerGetImgFactoryHeuristic();
        if (heuristic == null) {
            heuristic = new DefaultImgFactoryHeuristic();
        }
        return heuristic;
    }

    private Reader createReader(Location source, SCIFIOConfig config) throws ImgIOException {
        boolean computeMinMax = config.imgOpenerIsComputeMinMax();
        this.statusService.showStatus("Initializing " + source);
        ReaderFilter r = null;
        try {
            if (source instanceof FileLocation && !((FileLocation)source).getFile().exists()) {
                throw new IOException("File does not exist: " + source);
            }
            r = this.initializeService.initializeReader(source, config);
            r.enable(ChannelFiller.class);
            r.enable(PlaneSeparator.class).separate(this.axesToSplit(r));
            if (computeMinMax) {
                r.enable(MinMaxFilter.class);
            }
        }
        catch (FormatException | IOException e) {
            throw new ImgIOException(e);
        }
        return r;
    }

    private AxisType[] axesToSplit(ReaderFilter r) {
        HashSet<AxisType> axes = new HashSet<AxisType>();
        Metadata meta = r.getTail().getMetadata();
        for (CalibratedAxis t : meta.get(0).getAxesPlanar()) {
            AxisType type = t.type();
            if (type == Axes.X || type == Axes.Y) continue;
            axes.add(type);
        }
        axes.add(Axes.CHANNEL);
        return axes.toArray(new AxisType[axes.size()]);
    }

    private AxisType[] getAxisTypes(int imageIndex, Metadata m) {
        AxisType[] types = new AxisType[m.get(imageIndex).getAxes().size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = m.get(imageIndex).getAxis(i).type();
        }
        return types;
    }

    private double[] getCalibration(int imageIndex, Metadata m) {
        double[] calibration = new double[m.get(imageIndex).getAxes().size()];
        for (int i = 0; i < calibration.length; ++i) {
            calibration[i] = FormatTools.getScale(m, imageIndex, m.get(imageIndex).getAxis(i).type());
        }
        return calibration;
    }

    private <T> SCIFIOImgPlus<T> makeImgPlus(Img<T> img, Reader r, int imageIndex) {
        String colorMode;
        Location id = r.getCurrentLocation();
        String name = null;
        if (id != null) {
            name = id.getName();
        }
        if (name == null || name.equals("")) {
            name = "Image: " + r.getFormatName();
        }
        double[] cal = this.getCalibration(imageIndex, r.getMetadata());
        AxisType[] dimTypes = this.getAxisTypes(imageIndex, r.getMetadata());
        Reader base = this.unwrap(r);
        Metadata meta = r.getMetadata();
        int rgbChannelCount = base.getMetadata().get(0).isMultichannel() ? (int)base.getMetadata().get(0).getAxisLength(Axes.CHANNEL) : 1;
        int validBits = meta.get(0).getBitsPerPixel();
        SCIFIOImgPlus<T> imgPlus = new SCIFIOImgPlus<T>(img, name, dimTypes, cal);
        String metaName = meta.get(imageIndex).getName();
        if (metaName != null) {
            imgPlus.setName(metaName);
        }
        imgPlus.setValidBits(validBits);
        int compositeChannelCount = rgbChannelCount;
        if (rgbChannelCount == 1 && "composite".equals(colorMode = (String)meta.getTable().get("Color mode"))) {
            compositeChannelCount = (int)meta.get(0).getAxisLength(Axes.CHANNEL);
        }
        imgPlus.setCompositeChannelCount(compositeChannelCount);
        this.setCalibrationUnits(imgPlus, meta, imageIndex);
        return imgPlus;
    }

    private <T> void setCalibrationUnits(SCIFIOImgPlus<T> imgPlus, Metadata m, int imageIndex) {
        for (CalibratedAxis axis : m.get(imageIndex).getAxes()) {
            int index = imgPlus.dimensionIndex(axis.type());
            if (index < 0) continue;
            ((CalibratedAxis)imgPlus.axis(index)).setUnit(axis.unit());
        }
    }

    private Reader unwrap(Reader r) {
        if (!(r instanceof ReaderFilter)) {
            return r;
        }
        ReaderFilter rf = (ReaderFilter)r;
        return rf.getTail();
    }

    /*
     * WARNING - void declaration
     */
    private <T> void readPlanes(Reader r, int imageIndex, ImgPlus<T> imgPlus, SCIFIOConfig config) throws FormatException, IOException {
        void var21_27;
        PlanarAccess<ArrayDataAccess<?>> planarAccess = this.utils().getPlanarAccess(imgPlus);
        Type<?> inputType = this.utils().makeType(r.getMetadata().get(0).getPixelType());
        Object outputType = imgPlus.firstElement();
        boolean compatibleTypes = outputType.getClass().isAssignableFrom(inputType.getClass());
        boolean isPlanar = planarAccess != null && compatibleTypes;
        boolean isArray = this.utils().getArrayAccess(imgPlus) != null && compatibleTypes;
        ImageRegion region = config.imgOpenerGetRegion();
        Metadata m = r.getMetadata();
        List<CalibratedAxis> planarAxes = m.get(imageIndex).getAxesPlanar();
        int planarAxisCount = planarAxes.size();
        long[] planarMin = new long[planarAxisCount];
        long[] planarMax = new long[planarAxisCount];
        Range[] npRanges = new Range[m.get(imageIndex).getAxesNonPlanar().size()];
        long[] npIndices = new long[npRanges.length];
        int index = 0;
        for (CalibratedAxis calibratedAxis : planarAxes) {
            if (region != null && region.hasRange(calibratedAxis.type())) {
                planarMin[index] = region.getRange(calibratedAxis.type()).head();
                planarMax[index] = region.getRange(calibratedAxis.type()).tail();
            } else {
                planarMin[index] = 0L;
                planarMax[index] = m.get(imageIndex).getAxisLength(calibratedAxis) - 1L;
            }
            ++index;
        }
        FinalInterval bounds = new FinalInterval(planarMin, planarMax);
        index = 0;
        for (CalibratedAxis npAxis : m.get(imageIndex).getAxesNonPlanar()) {
            if (region != null && region.hasRange(npAxis.type())) {
                npRanges[index++] = region.getRange(npAxis.type());
                continue;
            }
            npRanges[index++] = new Range(0L, m.get(imageIndex).getAxisLength(npAxis.type()) - 1L);
        }
        PlaneConverter planeConverter = config.imgOpenerGetPlaneConverter();
        if (planeConverter == null) {
            if (isArray) {
                PlaneConverter planeConverter2 = this.pcService.getArrayConverter();
            } else if (isPlanar) {
                PlaneConverter planeConverter3 = this.pcService.getPlanarConverter();
            } else {
                PlaneConverter planeConverter4 = this.pcService.getDefaultConverter();
            }
        }
        this.read(imageIndex, imgPlus, r, config, (PlaneConverter)var21_27, (Interval)bounds, npRanges, npIndices);
        if (config.imgOpenerIsComputeMinMax()) {
            this.populateMinMax(r, imgPlus, imageIndex);
        }
    }

    private void read(int imageIndex, ImgPlus imgPlus, Reader r, SCIFIOConfig config, PlaneConverter converter, Interval bounds, Range[] npRanges, long[] npIndices) throws FormatException, IOException {
        this.read(imageIndex, imgPlus, r, config, converter, null, bounds, npRanges, npIndices, 0, new int[]{0});
    }

    private Plane read(int imageIndex, ImgPlus imgPlus, Reader r, SCIFIOConfig config, PlaneConverter converter, Plane tmpPlane, Interval bounds, Range[] npRanges, long[] npIndices, int depth, int[] planeCount) throws FormatException, IOException {
        if (depth < npRanges.length) {
            int npPosition = npRanges.length - 1 - depth;
            for (int i = 0; i < npRanges[npPosition].size(); ++i) {
                npIndices[npPosition] = (Long)npRanges[npPosition].get(i);
                tmpPlane = this.read(imageIndex, imgPlus, r, config, converter, tmpPlane, bounds, npRanges, npIndices, depth + 1, planeCount);
            }
        } else {
            int planeIndex = (int)FormatTools.positionToRaster(0, r, npIndices);
            if (config.imgOpenerIsComputeMinMax()) {
                this.populateMinMax(r, imgPlus, imageIndex);
            }
            tmpPlane = tmpPlane == null ? r.openPlane(imageIndex, (long)planeIndex, bounds) : r.openPlane(imageIndex, planeIndex, tmpPlane, bounds, config);
            converter.populatePlane(r, imageIndex, planeCount[0], tmpPlane.getBytes(), imgPlus, config);
            imgPlus.setColorTable(tmpPlane.getColorTable(), planeCount[0]);
            planeCount[0] = planeCount[0] + 1;
        }
        return tmpPlane;
    }

    private void populateMinMax(Reader r, ImgPlus<?> imgPlus, int imageIndex) {
        int sizeC = (int)r.getMetadata().get(imageIndex).getAxisLength(Axes.CHANNEL);
        ReaderFilter rf = (ReaderFilter)r;
        MinMaxFilter minMax = rf.enable(MinMaxFilter.class);
        for (int c = 0; c < sizeC; ++c) {
            Double min = minMax.getAxisKnownMinimum(imageIndex, Axes.CHANNEL, c);
            Double max = minMax.getAxisKnownMinimum(imageIndex, Axes.CHANNEL, c);
            imgPlus.setChannelMinimum(c, min == null ? Double.NaN : min);
            imgPlus.setChannelMaximum(c, max == null ? Double.NaN : max);
        }
    }

    private int i(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value too large: " + l);
        }
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Value too small: " + l);
        }
        return (int)l;
    }

    private Location resolve(String source) {
        try {
            return this.locationService.resolve(source);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory, T type) throws ImgIOException {
        return this.openImgs(source, imgFactory);
    }

    @Deprecated
    public <T extends RealType<T>> List<SCIFIOImgPlus<T>> openImgs(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        return this.openImgs(reader, imgFactory, config);
    }

    @Deprecated
    public SCIFIOImgPlus<?> openImg(String source) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source)));
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, T type) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source, type)));
    }

    @Deprecated
    public SCIFIOImgPlus<?> openImg(String source, SCIFIOConfig config) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source, config)));
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, T type, SCIFIOConfig config) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source, type, config)));
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source, imgFactory)));
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source, imgFactory, (T)config)));
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory, T type) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(source, imgFactory, type)));
    }

    @Deprecated
    public SCIFIOImgPlus<?> openImg(Reader reader, SCIFIOConfig config) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(reader, config)));
    }

    @Deprecated
    public <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(Reader reader, T type, SCIFIOConfig config) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(reader, type, config)));
    }

    @Deprecated
    public <T extends RealType<T>> SCIFIOImgPlus<T> openImg(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        return (SCIFIOImgPlus)((Object)ListUtils.first(this.openImgs(reader, type, imgFactory, config)));
    }
}

