/*
 * Decompiled with CFR 0.152.
 */
package fiji.debugging;

import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class Object_Inspector
implements PlugIn,
TreeWillExpandListener {
    DefaultMutableTreeNode windows;
    DefaultMutableTreeNode root;

    public void run(String arg) {
        this.windows = new DefaultMutableTreeNode("Windows");
        this.openFrame("Windows", this.windows);
    }

    public static void openFrame(String label, Object object) {
        new Object_Inspector().openFrame(label, new ObjectWrapper(label, object));
    }

    public void openFrame(String label, DefaultMutableTreeNode node) {
        Object_Inspector.node(node, label);
        this.root = new DefaultMutableTreeNode("Root");
        this.root.add(node);
        JTree tree = new JTree(this.root);
        tree.setRootVisible(false);
        tree.addTreeWillExpandListener(this);
        JScrollPane pane = new JScrollPane(tree);
        JFrame frame = new JFrame("Object Inspector");
        frame.setContentPane(pane);
        frame.setMinimumSize(new Dimension(600, 500));
        frame.pack();
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        Object leaf = e.getPath().getLastPathComponent();
        if (leaf == this.windows) {
            this.windows.removeAllChildren();
            for (Frame frame : Frame.getFrames()) {
                this.windows.add(new ObjectWrapper(frame));
            }
        } else if (leaf instanceof ObjectWrapper) {
            ObjectWrapper wrapper = (ObjectWrapper)leaf;
            if (wrapper.initialized) {
                return;
            }
            wrapper.removeAllChildren();
            Object object = wrapper.getUserObject();
            if (object == null) {
                Object_Inspector.node(wrapper, "<null>");
                return;
            }
            if (object.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    wrapper.add(new ObjectWrapper(object.getClass().getComponentType(), "[" + i + "]", Array.get(object, i)));
                }
                return;
            }
            for (Class<?> clazz = object.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                Object_Inspector.node(wrapper, "Fields of " + clazz.getName());
                for (Field field : clazz.getDeclaredFields()) {
                    wrapper.add(new ObjectWrapper(field, object));
                }
            }
            wrapper.initialized = true;
        }
    }

    protected static void node(DefaultMutableTreeNode parent, String title) {
        parent.add(new DefaultMutableTreeNode(title));
    }

    public static Object get(Object object, String fieldName) {
        if (object == null) {
            return "<object is null>";
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (Exception e) {
                continue;
            }
        }
        return "<could not access '" + fieldName + "'>";
    }

    protected static Object get(Field field, Object object) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static String getName(Class clazz, Object object) {
        if (clazz.isArray()) {
            return clazz.getComponentType() + "[" + (object == null ? "" : "" + Array.getLength(object)) + "]";
        }
        return clazz.getName();
    }

    protected static class ObjectWrapper
    extends DefaultMutableTreeNode {
        String title;
        boolean initialized;

        public ObjectWrapper(String title, Object object) {
            super(object);
            this.title = title;
            Object_Inspector.node(this, "Dummy");
        }

        public ObjectWrapper(Frame frame) {
            this(frame.getTitle(), (Object)frame);
        }

        public ObjectWrapper(Field field, Object object) {
            this(field.getType(), field.getName() + ((field.getModifiers() & 8) != 0 ? " [static]" : "") + " (" + Object_Inspector.getName(field.getType(), Object_Inspector.get(field, object)) + ")", Object_Inspector.get(field, object));
        }

        public ObjectWrapper(Class clazz, String title, Object object) {
            super(object);
            this.title = title;
            if (clazz.isPrimitive() || clazz == String.class) {
                this.title = this.title + ": " + ObjectWrapper.toString(object);
                this.initialized = true;
            } else {
                Object_Inspector.node(this, "Dummy");
            }
        }

        protected static String toString(Object object) {
            return object == null ? "<null>" : object.toString();
        }

        @Override
        public String toString() {
            return this.title;
        }
    }
}

