/*
 * Decompiled with CFR 0.152.
 */
package fiji.tool;

import fiji.tool.SliceListener;
import fiji.tool.SliceObserver;
import fiji.tool.ToolToggleListener;
import fiji.tool.ToolWithOptions;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTool
implements ImageListener,
WindowFocusListener,
PlugIn {
    protected Toolbar toolbar;
    protected int toolID = -1;
    protected MouseProxy mouseProxy;
    protected MouseWheelProxy mouseWheelProxy;
    protected MouseMotionProxy mouseMotionProxy;
    protected KeyProxy keyProxy;
    protected KeyProxyIfNotConsumed ijKeyProxy;
    protected SliceListener sliceListener;
    protected List<SliceObserver> sliceObservers = new ArrayList<SliceObserver>();
    protected ToolbarMouseAdapter toolbarMouseListener;
    protected ToolToggleListener toolToggleListener;
    protected String savedToolName;
    protected boolean clearToolsIfNecessary;
    protected boolean toolActive;

    public void run(String arg) {
        this.toolbar = Toolbar.getInstance();
        if (this.toolbar == null) {
            IJ.error((String)"No toolbar found");
            return;
        }
        boolean clearTools = false;
        if (this.toolbar.getToolId(this.getToolName()) >= 0) {
            if (this.clearToolsIfNecessary) {
                clearTools = true;
            } else {
                IJ.error((String)("Tool '" + this.getToolName() + "' already present!"));
                return;
            }
        }
        this.toolID = -1;
        if (!clearTools) {
            this.toolID = this.toolbar.addTool(this.getToolName() + " - " + this.getToolIcon());
        }
        if (this.toolID < 0 && this.clearToolsIfNecessary) {
            AbstractTool abstractTool = this;
            int previousID = abstractTool.toolbar.getToolId();
            this.toolbar.addMacroTool(this.getToolName() + " - " + this.getToolIcon(), null, 0);
            this.toolID = this.toolbar.getToolId(this.getToolName());
            if (previousID == this.toolID) {
                this.toolbar.repaint();
            }
        }
        if (this.toolID < 0) {
            IJ.error((String)"Could not register tool");
            return;
        }
        this.toolbar.setTool(this.toolID);
        AbstractTool abstractTool = this;
        if (abstractTool.toolbar.getToolId() != this.toolID) {
            IJ.error((String)("Could not set tool (id = " + this.toolID + ")"));
            return;
        }
        this.savedToolName = Toolbar.getToolName();
        if (this instanceof MouseListener) {
            this.mouseProxy = new MouseProxy((MouseListener)((Object)this));
        }
        if (this instanceof MouseMotionListener) {
            this.mouseMotionProxy = new MouseMotionProxy((MouseMotionListener)((Object)this));
        }
        if (this instanceof MouseWheelListener) {
            this.mouseWheelProxy = new MouseWheelProxy((MouseWheelListener)((Object)this));
        }
        if (this instanceof KeyListener) {
            this.keyProxy = new KeyProxy((KeyListener)((Object)this));
            this.ijKeyProxy = new KeyProxyIfNotConsumed((KeyListener)IJ.getInstance());
        }
        if (this instanceof SliceListener) {
            this.sliceListener = (SliceListener)((Object)this);
        }
        if (this instanceof ToolWithOptions) {
            this.toolbarMouseListener = new ToolbarMouseAdapter((ToolWithOptions)((Object)this));
        }
        if (this instanceof ToolToggleListener) {
            this.toolToggleListener = (ToolToggleListener)((Object)this);
            this.toolToggleListener.toolToggled(true);
            if (this.toolbarMouseListener == null) {
                this.toolbarMouseListener = new ToolbarMouseAdapter(null);
            }
        }
        this.toolActive = true;
        this.registerTool();
    }

    public void imageOpened(ImagePlus image) {
        this.registerTool(image);
    }

    public void imageClosed(ImagePlus image) {
        this.unregisterTool(image);
    }

    public void imageUpdated(ImagePlus image) {
        if (this.maybeUnregister()) {
            return;
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (this.maybeUnregister()) {
            return;
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.maybeUnregister()) {
            return;
        }
    }

    public final int getToolID() {
        return this.toolID;
    }

    public final boolean isThisTool() {
        boolean active;
        boolean bl = active = Toolbar.getToolId() == this.toolID;
        if (this.toolToggleListener != null && active != this.toolActive) {
            this.toolToggleListener.toolToggled(active);
        }
        this.toolActive = active;
        return active;
    }

    protected void registerTool() {
        int[] ids = WindowManager.getIDList();
        if (ids != null) {
            for (int id : ids) {
                this.registerTool(WindowManager.getImage((int)id));
            }
        }
        if (this.toolbarMouseListener != null) {
            this.toolbar.addMouseListener((MouseListener)this.toolbarMouseListener);
        }
        ImagePlus.addImageListener((ImageListener)this);
        IJ.getInstance().addWindowFocusListener((WindowFocusListener)this);
    }

    protected void registerTool(ImagePlus image) {
        ImageWindow window;
        if (image == null) {
            return;
        }
        if (this.sliceListener != null) {
            this.sliceObservers.add(new SliceObserver(image, new SliceListener(){

                @Override
                public final void sliceChanged(ImagePlus image) {
                    if (AbstractTool.this.maybeUnregister()) {
                        return;
                    }
                    if (AbstractTool.this.isThisTool()) {
                        AbstractTool.this.sliceListener.sliceChanged(image);
                    }
                }
            }));
        }
        if (image.getCanvas() != null) {
            this.registerTool(image.getCanvas());
        }
        if ((window = image.getWindow()) != null) {
            window.addWindowFocusListener((WindowFocusListener)this);
            if (this.keyProxy != null) {
                this.addKeyListener((Component)window);
            }
            this.addMouseWheelListener(window);
        }
    }

    protected void registerTool(ImageCanvas canvas) {
        if (canvas == null) {
            return;
        }
        if (this.mouseProxy != null) {
            canvas.addMouseListener((MouseListener)this.mouseProxy);
        }
        this.addMouseMotionListener(canvas);
        this.addKeyListener((Component)canvas);
    }

    protected void addKeyListener(Component component) {
        if (this.keyProxy != null) {
            component.addKeyListener(this.keyProxy);
            KeyListener ij = null;
            for (KeyListener listener : component.getKeyListeners()) {
                if (listener != this.ijKeyProxy.listener && !listener.getClass().getName().endsWith("KeyProxyIfNotConsumed")) continue;
                ij = listener;
            }
            if (ij == null) {
                ij = this.ijKeyProxy;
            } else {
                component.removeKeyListener(ij);
                if (ij == this.ijKeyProxy.listener) {
                    ij = this.ijKeyProxy;
                }
            }
            component.addKeyListener(ij);
        }
    }

    protected void addMouseMotionListener(ImageCanvas canvas) {
        if (this.mouseMotionProxy != null) {
            canvas.addMouseMotionListener((MouseMotionListener)this.mouseMotionProxy);
            MouseMotionListener listener = null;
            for (MouseMotionListener listener2 : canvas.getMouseMotionListeners()) {
                if (listener2 != canvas && !listener2.getClass().getName().endsWith("MouseMotionProxyIfNotConsumed")) continue;
                listener = listener2;
            }
            if (listener == null) {
                listener = new MouseMotionProxyIfNotConsumed((MouseMotionListener)canvas);
            } else {
                canvas.removeMouseMotionListener(listener);
                if (listener == canvas) {
                    listener = new MouseMotionProxyIfNotConsumed((MouseMotionListener)canvas);
                }
            }
            canvas.addMouseMotionListener(listener);
        }
    }

    protected void addMouseWheelListener(ImageWindow window) {
        if (this.mouseWheelProxy != null) {
            window.addMouseWheelListener((MouseWheelListener)this.mouseWheelProxy);
            MouseWheelListener listener = null;
            for (MouseWheelListener listener2 : window.getMouseWheelListeners()) {
                if (listener2 != window && !listener2.getClass().getName().endsWith("MouseWheelProxyIfNotConsumed")) continue;
                listener = listener2;
            }
            if (listener == null) {
                listener = new MouseWheelProxyIfNotConsumed((MouseWheelListener)window);
            } else {
                window.removeMouseWheelListener(listener);
                if (listener == window) {
                    listener = new MouseWheelProxyIfNotConsumed((MouseWheelListener)window);
                }
            }
            window.addMouseWheelListener(listener);
        }
    }

    protected boolean maybeUnregister() {
        if (!this.wasToolbarCleared()) {
            return false;
        }
        this.unregisterTool();
        IJ.showStatus((String)("unregistered " + this.getToolName() + " Tool"));
        return true;
    }

    protected boolean wasToolbarCleared() {
        Toolbar current = Toolbar.getInstance();
        if (current != this.toolbar) {
            return true;
        }
        return Toolbar.getToolId() == this.toolID && Toolbar.getToolName() != this.savedToolName;
    }

    protected void unregisterTool() {
        if (this.toolToggleListener != null && this.toolActive) {
            this.toolToggleListener.toolToggled(false);
            this.toolActive = false;
        }
        for (int id : WindowManager.getIDList()) {
            this.unregisterTool(WindowManager.getImage((int)id));
        }
        ImagePlus.removeImageListener((ImageListener)this);
        Object object = this.sliceObservers.iterator();
        while (object.hasNext()) {
            SliceObserver observer = (SliceObserver)object.next();
            observer.unregister();
        }
        this.sliceObservers.clear();
        if (this.toolbarMouseListener != null) {
            this.toolbar.removeMouseListener((MouseListener)this.toolbarMouseListener);
        }
        IJ.getInstance().removeWindowFocusListener((WindowFocusListener)this);
    }

    protected void unregisterTool(ImagePlus image) {
        if (image == null) {
            return;
        }
        Iterator<SliceObserver> iter = this.sliceObservers.iterator();
        while (iter.hasNext()) {
            SliceObserver observer = iter.next();
            if (observer.getImagePlus() != image) continue;
            observer.unregister();
            iter.remove();
        }
        if (image.getCanvas() != null) {
            this.unregisterTool(image.getCanvas());
        }
        if (image.getWindow() != null) {
            image.getWindow().removeWindowFocusListener((WindowFocusListener)this);
            if (this.keyProxy != null) {
                image.getWindow().removeKeyListener((KeyListener)this.keyProxy);
            }
        }
    }

    protected void unregisterTool(ImageCanvas canvas) {
        if (canvas == null) {
            return;
        }
        if (this.mouseProxy != null) {
            canvas.removeMouseListener((MouseListener)this.mouseProxy);
        }
        if (this.mouseMotionProxy != null) {
            canvas.removeMouseMotionListener((MouseMotionListener)this.mouseMotionProxy);
        }
        if (this.mouseWheelProxy != null) {
            canvas.removeMouseWheelListener((MouseWheelListener)this.mouseWheelProxy);
        }
        if (this.keyProxy != null) {
            canvas.removeKeyListener((KeyListener)this.keyProxy);
        }
    }

    public ImagePlus getImagePlus(ComponentEvent e) {
        ImageCanvas canvas = this.getImageCanvas(e);
        return canvas == null ? null : canvas.getImage();
    }

    public ImageCanvas getImageCanvas(ComponentEvent e) {
        Component component = e.getComponent();
        return component instanceof ImageCanvas ? (ImageCanvas)component : (component instanceof ImageWindow ? ((ImageWindow)component).getCanvas() : null);
    }

    public ImageWindow getImageWindow(ComponentEvent e) {
        for (Component component = e.getComponent(); component != null; component = component.getParent()) {
            if (!(component instanceof ImageWindow)) continue;
            return (ImageWindow)component;
        }
        return null;
    }

    public int getOffscreenX(MouseEvent e) {
        ImageCanvas canvas = this.getImageCanvas(e);
        return canvas == null ? -1 : canvas.offScreenX(e.getX());
    }

    public int getOffscreenY(MouseEvent e) {
        ImageCanvas canvas = this.getImageCanvas(e);
        return canvas == null ? -1 : canvas.offScreenY(e.getY());
    }

    public double getOffscreenXDouble(MouseEvent e) {
        ImageCanvas canvas = this.getImageCanvas(e);
        return canvas == null ? -1.0 : canvas.offScreenXD(e.getX());
    }

    public double getOffscreenYDouble(MouseEvent e) {
        ImageCanvas canvas = this.getImageCanvas(e);
        return canvas == null ? -1.0 : canvas.offScreenXD(e.getY());
    }

    public String getToolName() {
        return this.getClass().getName().replace('_', ' ');
    }

    public String getToolIcon() {
        return "C00aT0509NT5509eT9509wT0e09TT3e09oT8e09oTde09l";
    }

    protected class KeyProxyIfNotConsumed
    implements KeyListener {
        protected KeyListener listener;

        public KeyProxyIfNotConsumed(KeyListener listener) {
            this.listener = listener;
        }

        @Override
        public final void keyPressed(KeyEvent e) {
            if (!e.isConsumed()) {
                this.listener.keyPressed(e);
            }
        }

        @Override
        public final void keyReleased(KeyEvent e) {
            if (!e.isConsumed()) {
                this.listener.keyReleased(e);
            }
        }

        @Override
        public final void keyTyped(KeyEvent e) {
            if (!e.isConsumed()) {
                this.listener.keyTyped(e);
            }
        }
    }

    protected class KeyProxy
    implements KeyListener {
        protected KeyListener listener;

        public KeyProxy(KeyListener listener) {
            this.listener = listener;
        }

        @Override
        public final void keyPressed(KeyEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.keyPressed(e);
            }
        }

        @Override
        public final void keyReleased(KeyEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.keyReleased(e);
            }
        }

        @Override
        public final void keyTyped(KeyEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.keyTyped(e);
            }
        }
    }

    protected class MouseMotionProxyIfNotConsumed
    implements MouseMotionListener {
        protected MouseMotionListener listener;

        public MouseMotionProxyIfNotConsumed(MouseMotionListener listener) {
            this.listener = listener;
        }

        @Override
        public final void mouseDragged(MouseEvent e) {
            if (!e.isConsumed()) {
                this.listener.mouseDragged(e);
            }
        }

        @Override
        public final void mouseMoved(MouseEvent e) {
            if (!e.isConsumed()) {
                this.listener.mouseMoved(e);
            }
        }
    }

    protected class MouseMotionProxy
    implements MouseMotionListener {
        protected MouseMotionListener listener;

        public MouseMotionProxy(MouseMotionListener listener) {
            this.listener = listener;
        }

        @Override
        public final void mouseDragged(MouseEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseDragged(e);
            }
        }

        @Override
        public final void mouseMoved(MouseEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseMoved(e);
            }
        }
    }

    protected class MouseWheelProxyIfNotConsumed
    implements MouseWheelListener {
        protected MouseWheelListener listener;

        public MouseWheelProxyIfNotConsumed(MouseWheelListener listener) {
            this.listener = listener;
        }

        @Override
        public final void mouseWheelMoved(MouseWheelEvent e) {
            if (!e.isConsumed()) {
                this.listener.mouseWheelMoved(e);
            }
        }
    }

    protected class MouseWheelProxy
    implements MouseWheelListener {
        protected MouseWheelListener listener;

        public MouseWheelProxy(MouseWheelListener listener) {
            this.listener = listener;
        }

        @Override
        public final void mouseWheelMoved(MouseWheelEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseWheelMoved(e);
            }
        }
    }

    protected class MouseProxy
    implements MouseListener {
        protected MouseListener listener;

        public MouseProxy(MouseListener listener) {
            this.listener = listener;
        }

        @Override
        public final void mousePressed(MouseEvent e) {
            if (AbstractTool.this.maybeUnregister()) {
                return;
            }
            if (AbstractTool.this.isThisTool()) {
                this.listener.mousePressed(e);
            }
        }

        @Override
        public final void mouseReleased(MouseEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseReleased(e);
            }
        }

        @Override
        public final void mouseClicked(MouseEvent e) {
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseClicked(e);
            }
        }

        @Override
        public final void mouseEntered(MouseEvent e) {
            if (AbstractTool.this.maybeUnregister()) {
                return;
            }
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseEntered(e);
            }
        }

        @Override
        public final void mouseExited(MouseEvent e) {
            if (AbstractTool.this.maybeUnregister()) {
                return;
            }
            if (AbstractTool.this.isThisTool()) {
                this.listener.mouseExited(e);
            }
        }
    }

    protected class ToolbarMouseAdapter
    extends MouseAdapter {
        protected ToolWithOptions this2;

        public ToolbarMouseAdapter(ToolWithOptions tool) {
            this.this2 = tool;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (AbstractTool.this.maybeUnregister()) {
                return;
            }
            if (AbstractTool.this.isThisTool() && this.this2 != null && e.getClickCount() > 1) {
                this.this2.showOptionDialog();
            }
        }
    }
}

