/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;

class MouseState {
    static final int WHEEL_NONE = 0;
    static final int WHEEL_UP = 1;
    static final int WHEEL_DOWN = -1;
    private int x;
    private int y;
    private int wheel;
    private MonocleWindow window;
    private IntSet buttonsPressed = new IntSet();

    MouseState() {
    }

    int getX() {
        return this.x;
    }

    void setX(int n) {
        this.x = n;
    }

    int getY() {
        return this.y;
    }

    void setY(int n) {
        this.y = n;
    }

    int getWheel() {
        return this.wheel;
    }

    void setWheel(int n) {
        this.wheel = n;
    }

    void pressButton(int n) {
        this.buttonsPressed.addInt(n);
    }

    void releaseButton(int n) {
        this.buttonsPressed.removeInt(n);
    }

    MonocleWindow getWindow(boolean bl) {
        if (this.window == null || bl) {
            this.window = MonocleWindowManager.getInstance().getWindowForLocation(this.x, this.y);
        }
        return this.window;
    }

    int getButton() {
        return this.buttonsPressed.isEmpty() ? 211 : this.buttonsPressed.get(0);
    }

    int getModifiers() {
        int n = 0;
        block5: for (int i = 0; i < this.buttonsPressed.size(); ++i) {
            switch (this.buttonsPressed.get(i)) {
                case 212: {
                    n |= 0x20;
                    continue block5;
                }
                case 214: {
                    n |= 0x80;
                    continue block5;
                }
                case 213: {
                    n |= 0x40;
                }
            }
        }
        return n;
    }

    void copyTo(MouseState mouseState) {
        mouseState.x = this.x;
        mouseState.y = this.y;
        mouseState.wheel = this.wheel;
        this.buttonsPressed.copyTo(mouseState.buttonsPressed);
        mouseState.window = this.window;
    }

    IntSet getButtonsPressed() {
        return this.buttonsPressed;
    }

    public String toString() {
        return "MouseState[x=" + this.x + ",y=" + this.y + ",wheel=" + this.wheel + ",buttonsPressed=" + this.buttonsPressed + "]";
    }

    boolean canBeFoldedWith(MouseState mouseState) {
        return mouseState.buttonsPressed.equals(this.buttonsPressed) && mouseState.wheel == this.wheel;
    }
}

