/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.viewer.image;

import net.imagej.Dataset;
import net.imagej.ui.swing.viewer.image.JHotDrawImageCanvas;
import net.imagej.ui.swing.viewer.image.SwingImageDisplayPanel;
import net.imagej.ui.swing.viewer.image.SwingImageDisplayViewer;
import net.imagej.ui.viewer.image.AbstractImageDisplayViewer;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.options.event.OptionsEvent;
import org.scijava.plugin.Parameter;
import org.scijava.ui.awt.AWTDropTargetEventDispatcher;
import org.scijava.ui.awt.AWTInputEventDispatcher;
import org.scijava.ui.viewer.DisplayWindow;

public abstract class AbstractSwingImageDisplayViewer
extends AbstractImageDisplayViewer
implements SwingImageDisplayViewer {
    protected AWTInputEventDispatcher dispatcher;
    @Parameter
    private EventService eventService;
    private JHotDrawImageCanvas imgCanvas;
    private SwingImageDisplayPanel imgPanel;

    @Override
    public JHotDrawImageCanvas getCanvas() {
        return this.imgCanvas;
    }

    @Override
    public void view(DisplayWindow w, Display<?> d) {
        super.view(w, d);
        ((DisplayService)this.getContext().service(DisplayService.class)).setActiveDisplay((Display)this.getDisplay());
        this.dispatcher = new AWTInputEventDispatcher((Display)this.getDisplay(), this.eventService);
        this.imgCanvas = new JHotDrawImageCanvas(this);
        this.imgCanvas.addEventDispatcher(this.dispatcher);
        AWTDropTargetEventDispatcher dropDispatcher = new AWTDropTargetEventDispatcher((Display)this.getDisplay(), this.eventService);
        this.imgCanvas.addEventDispatcher(dropDispatcher);
        this.imgPanel = new SwingImageDisplayPanel(this, this.getWindow());
        this.setPanel(this.imgPanel);
        this.updateTitle();
    }

    @Override
    public SwingImageDisplayPanel getPanel() {
        return this.imgPanel;
    }

    @Override
    public Dataset capture() {
        return this.getCanvas().capture();
    }

    public void dispose() {
        super.dispose();
        if (this.imgCanvas != null) {
            this.imgCanvas.dispose();
            this.imgCanvas = null;
        }
    }

    @EventHandler
    protected void onEvent(OptionsEvent e) {
        this.updateLabel();
    }
}

