/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.binary;

import java.util.Vector;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.converter.Converter;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;

public class Thresholder {
    public static final <T extends Type<T> & Comparable<T>> Img<BitType> threshold(final Img<T> source, final T threshold, boolean above, int numThreads) {
        ImgFactory<T> factory = source.factory();
        try {
            ImgFactory<BitType> bitFactory = factory.imgFactory(new BitType());
            final Img<BitType> target = bitFactory.create(source);
            final Converter converter = above ? new Converter<T, BitType>(){

                @Override
                public void convert(T input, BitType output) {
                    output.set(((Comparable)input).compareTo(threshold) > 0);
                }
            } : new Converter<T, BitType>(){

                @Override
                public void convert(T input, BitType output) {
                    output.set(((Comparable)input).compareTo(threshold) < 0);
                }
            };
            Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
            Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
            if (target.iterationOrder().equals(source.iterationOrder())) {
                for (int i = 0; i < threads.length; ++i) {
                    final Chunk chunk = chunks.get(i);
                    threads[i] = new Thread("Thresholder thread " + i){

                        @Override
                        public void run() {
                            RealCursor cursorTarget = target.cursor();
                            cursorTarget.jumpFwd(chunk.getStartPosition());
                            RealCursor cursorSource = source.cursor();
                            cursorSource.jumpFwd(chunk.getStartPosition());
                            for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                                cursorTarget.fwd();
                                cursorSource.fwd();
                                converter.convert(cursorSource.get(), cursorTarget.get());
                            }
                        }
                    };
                }
            } else {
                for (int i = 0; i < threads.length; ++i) {
                    final Chunk chunk = chunks.get(i);
                    threads[i] = new Thread("Thresholder thread " + i){

                        @Override
                        public void run() {
                            RealCursor cursorTarget = target.cursor();
                            cursorTarget.jumpFwd(chunk.getStartPosition());
                            RandomAccess ra = source.randomAccess(target);
                            for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                                cursorTarget.fwd();
                                ra.setPosition((Localizable)((Object)cursorTarget));
                                converter.convert(ra.get(), cursorTarget.get());
                            }
                        }
                    };
                }
            }
            SimpleMultiThreading.startAndJoin(threads);
            return target;
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
            return null;
        }
    }
}

