/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.matrix;

import net.imglib2.algorithm.linalg.matrix.RealCompositeSquareMatrix;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;

public class RealCompositeSymmetricMatrix<T extends RealType<T>>
extends RealCompositeSquareMatrix<T> {
    public RealCompositeSymmetricMatrix(Composite<T> data, int nRowsOrCols) {
        this(data, nRowsOrCols, nRowsOrCols * (nRowsOrCols + 1) / 2);
    }

    protected RealCompositeSymmetricMatrix(Composite<T> data, int nRowsOrCols, int length) {
        super(data, nRowsOrCols, length);
    }

    @Override
    public long rowAndColumnToLinear(long row, long col) {
        if (row < col) {
            long rowDiff = (long)this.nRows - row;
            long n = rowDiff * (rowDiff + 1L) / 2L;
            return (long)this.length - n + col - row;
        }
        long rowDiff = (long)this.nRows - col;
        long n = rowDiff * (rowDiff + 1L) / 2L;
        return (long)this.length - n + row - col;
    }
}

