/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.Map;
import java.util.stream.LongStream;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.RandomAccessOnly;
import net.imglib2.algorithm.math.abstractions.ViewableFunction;
import net.imglib2.algorithm.math.execution.BlockReadingDirect;
import net.imglib2.algorithm.math.execution.BlockReadingSource;
import net.imglib2.algorithm.math.execution.LetBinding;
import net.imglib2.algorithm.math.execution.Variable;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;

public final class BlockReadSource<I extends RealType<I>>
extends ViewableFunction
implements IFunction,
RandomAccessOnly<I> {
    private final RandomAccessible<I> src;
    private final long[][] corners;
    private final byte[] signs;

    public BlockReadSource(RandomAccessible<I> src, long[] blockRadius) {
        this.src = src;
        this.corners = new long[(int)Math.pow(2.0, blockRadius.length)][blockRadius.length];
        for (int d = 0; d < src.numDimensions(); ++d) {
            int cycle = this.corners.length / (int)Math.pow(2.0, d + 1);
            long inc = blockRadius[d];
            for (int i = 0; i < this.corners.length; ++i) {
                if (0 == i % cycle) {
                    inc *= -1L;
                }
                this.corners[i][d] = inc;
            }
        }
        this.signs = BlockReadSource.signsArray(src);
    }

    public BlockReadSource(RandomAccessible<I> src, long blockRadius) {
        this(src, LongStream.generate(() -> blockRadius).limit(src.numDimensions()).toArray());
    }

    public static byte[] signsArray(RandomAccessible<?> src) {
        switch (src.numDimensions()) {
            case 1: {
                return new byte[]{-1, 1};
            }
            case 2: {
                return new byte[]{1, -1, -1, 1};
            }
            case 3: {
                return new byte[]{-1, 1, 1, -1, 1, -1, -1, 1};
            }
        }
        throw new UnsupportedOperationException("Sorry, numDimensions " + src.numDimensions() + " not supported yet.");
    }

    public BlockReadSource(RandomAccessible<I> src, long[][] corners) {
        this.src = src;
        this.corners = corners;
        this.signs = BlockReadSource.signsArray(src);
    }

    @Override
    public <O extends RealType<O>> OFunction<O> reInit(O tmp, Map<String, LetBinding<O>> bindings, Converter<RealType<?>, O> converter, Map<Variable<O>, OFunction<O>> imgSources) {
        if (tmp.getClass() == ((RealType)this.src.randomAccess().get()).getClass()) {
            return new BlockReadingDirect<RealType>((RealType)tmp.copy(), this.src, this.corners, this.signs);
        }
        return new BlockReadingSource<I, RealType>((RealType)tmp.copy(), converter, this.src, this.corners, this.signs);
    }

    @Override
    public RandomAccessible<I> getRandomAccessible() {
        return this.src;
    }
}

