/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.View;
import net.imglib2.algorithm.math.Compute;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.Util;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class IterableRandomAccessibleFunction<C extends RealType<C>, O extends RealType<O>>
extends AbstractInterval
implements RandomAccessibleInterval<O>,
IterableInterval<O>,
View {
    protected final IFunction operation;
    private final RandomAccessibleInterval<?> firstImg;
    protected final C computeType;
    protected final O outputType;
    protected final Converter<RealType<?>, C> inConverter;
    protected final Converter<C, O> outConverter;

    public IterableRandomAccessibleFunction(IFunction operation, Converter<RealType<?>, C> inConverter, C computeType, O outputType, Converter<C, O> outConverter) {
        super(Util.findFirstInterval(operation));
        this.operation = operation;
        this.firstImg = Util.findFirstImg(operation);
        this.computeType = computeType;
        this.outputType = outputType;
        this.inConverter = inConverter;
        this.outConverter = outConverter;
    }

    public IterableRandomAccessibleFunction(IFunction operation, O outputType) {
        this(operation, null, (RealType)outputType.createVariable(), outputType, null);
    }

    public IterableRandomAccessibleFunction(IFunction operation, O outputType, Converter<C, O> outConverter) {
        this(operation, null, (RealType)outputType.createVariable(), outputType, outConverter);
    }

    public IterableRandomAccessibleFunction(IFunction operation) {
        this(operation, (RealType)((RealType)Util.findFirstImg(operation).randomAccess().get()).createVariable());
    }

    @Override
    public RandomAccess<O> randomAccess() {
        return new Compute(this.operation).randomAccess(this.computeType, this.outputType, this.outConverter);
    }

    @Override
    public RandomAccess<O> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    @Override
    public O firstElement() {
        return (O)((RealType)this.randomAccess().get());
    }

    @Override
    public Object iterationOrder() {
        return Views.iterable(this.firstImg).iterationOrder();
    }

    @Override
    public long size() {
        return Intervals.numElements(this.firstImg);
    }

    @Override
    public Iterator<O> iterator() {
        return this.cursor();
    }

    @Override
    public Cursor<O> cursor() {
        return new Compute(this.operation).cursor(this.inConverter, this.computeType, this.outputType, this.outConverter);
    }

    @Override
    public Cursor<O> localizingCursor() {
        return this.cursor();
    }

    @Override
    public O getType() {
        return this.outputType;
    }
}

