/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhood;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class PeriodicLineShape
implements Shape {
    private final long span;
    private final int[] increments;

    public PeriodicLineShape(long span, int[] increments) {
        if (span < 0L) {
            throw new IllegalArgumentException("Span cannot be negative.");
        }
        this.span = span;
        this.increments = increments;
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        PeriodicLineNeighborhoodFactory f = PeriodicLineNeighborhoodUnsafe.factory();
        return new NeighborhoodsIterableInterval<T>(source, this.span, this.increments, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        PeriodicLineNeighborhoodFactory f = PeriodicLineNeighborhoodUnsafe.factory();
        return new NeighborhoodsAccessible<T>(source, this.span, this.increments, f);
    }

    @Override
    public <T> IterableInterval<Neighborhood<T>> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        PeriodicLineNeighborhoodFactory f = PeriodicLineNeighborhood.factory();
        return new NeighborhoodsIterableInterval<T>(source, this.span, this.increments, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        PeriodicLineNeighborhoodFactory f = PeriodicLineNeighborhood.factory();
        return new NeighborhoodsAccessible<T>(source, this.span, this.increments, f);
    }

    public long getSpan() {
        return this.span;
    }

    public int[] getIncrements() {
        return (int[])this.increments.clone();
    }

    public String toString() {
        return "PeriodicLineShape, span = " + this.span + ", increments = " + Util.printCoordinates(this.increments);
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] a = new long[numDimensions];
        long[] b = new long[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            a[i] = (long)this.increments[i] * -this.getSpan();
            b[i] = (long)this.increments[i] * this.getSpan();
        }
        return Intervals.union(new FinalInterval(a, a), new FinalInterval(b, b));
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final PeriodicLineNeighborhoodFactory<T> factory;
        private final long span;
        private final int[] increments;

        public NeighborhoodsAccessible(RandomAccessible<T> source, long span, int[] increments, PeriodicLineNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.span = span;
            this.increments = increments;
            this.factory = factory;
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new PeriodicLineNeighborhoodRandomAccess<T>(this.source, this.span, this.increments, this.factory);
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        @Override
        public Neighborhood<T> getType() {
            return (Neighborhood)this.randomAccess().getType();
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final long span;
        final PeriodicLineNeighborhoodFactory<T> factory;
        final long size;
        final int[] increments;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, long span, int[] increments, PeriodicLineNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.span = span;
            this.increments = increments;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        @Override
        public Cursor<Neighborhood<T>> cursor() {
            return new PeriodicLineNeighborhoodCursor<T>(this.source, this.span, this.increments, this.factory);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        @Override
        public Neighborhood<T> getType() {
            return (Neighborhood)this.cursor().getType();
        }

        @Override
        public Object iterationOrder() {
            return new FlatIterationOrder(this);
        }

        @Override
        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

