/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;

public class Slice_Remover
implements PlugIn {
    private static int first = 1;
    private static int last = 9999;
    private static int inc = 2;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageStack stack = imp.getStack();
        if (stack.getSize() == 1) {
            IJ.error((String)"Stack Required");
            return;
        }
        if (!this.showDialog(stack)) {
            return;
        }
        this.removeSlices(stack, first, last, inc);
        imp.setStack(null, stack);
        IJ.register(Slice_Remover.class);
    }

    public boolean showDialog(ImageStack stack) {
        if (last > stack.getSize()) {
            last = stack.getSize();
        }
        GenericDialog gd = new GenericDialog("Slice Remover");
        gd.addNumericField("First Slice:", (double)first, 0);
        gd.addNumericField("Last Slice:", (double)last, 0);
        gd.addNumericField("Increment:", (double)inc, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        first = (int)gd.getNextNumber();
        last = (int)gd.getNextNumber();
        inc = (int)gd.getNextNumber();
        return true;
    }

    public void removeSlices(ImageStack stack, int first, int last, int inc) {
        if (last > stack.getSize()) {
            last = stack.getSize();
        }
        int count = 0;
        for (int i = first; i <= last && i - count <= stack.getSize(); i += inc) {
            stack.deleteSlice(i - count);
            ++count;
        }
    }
}

