/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.control.mcu;

import gnu.trove.map.hash.TIntIntHashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import org.janelia.saalfeldlab.control.mcu.MCUButtonControl;
import org.janelia.saalfeldlab.control.mcu.MCUControl;
import org.janelia.saalfeldlab.control.mcu.MCUControlPanel;
import org.janelia.saalfeldlab.control.mcu.MCUFaderControl;
import org.janelia.saalfeldlab.control.mcu.MCUVPotControl;

public class XTouchMiniMCUControlPanel
extends MCUControlPanel {
    private static final String DEFAULT_DEVICE_DESCRIPTION = "X-TOUCH MINI";
    private final int[] vpotIds = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private final int[] vpotLedIds = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private final MCUVPotControl[] vpots = new MCUVPotControl[8];
    private final TIntIntHashMap vpotIndexMap = new TIntIntHashMap(this.vpotIds.length, 0.5f, -1, -1);
    private final int[] keyIds;
    private final int[] keyLedIds;
    private final MCUButtonControl[] keys;
    private final TIntIntHashMap keyIndexMap;
    private final MCUFaderControl fader;

    public XTouchMiniMCUControlPanel(Transmitter trans, Receiver rec) {
        super(trans, rec);
        int i;
        for (i = 0; i < this.vpotIds.length; ++i) {
            this.vpotIndexMap.put(this.vpotIds[i], i);
        }
        this.keyIds = new int[]{89, 90, 40, 41, 42, 43, 44, 45, 87, 88, 91, 92, 86, 93, 94, 95, 84, 85, 32, 33, 34, 35, 36, 37, 38, 39};
        this.keyLedIds = new int[]{89, 90, 40, 41, 42, 43, 44, 45, 87, 88, 91, 92, 86, 93, 94, 95, 84, 85, -1, -1, -1, -1, -1, -1, -1, -1};
        this.keys = new MCUButtonControl[26];
        this.keyIndexMap = new TIntIntHashMap(this.keyIds.length, 0.5f, -1, -1);
        for (i = 0; i < this.keyIds.length; ++i) {
            this.keyIndexMap.put(this.keyIds[i], i);
        }
        this.fader = new MCUFaderControl();
        for (i = 0; i < this.vpots.length; ++i) {
            this.vpots[i] = new MCUVPotControl(this.vpotLedIds[i], rec);
        }
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new MCUButtonControl(this.keyLedIds[i], rec);
        }
    }

    @Override
    public MCUVPotControl getVPotControl(int i) {
        return this.vpots[i];
    }

    @Override
    protected MCUVPotControl getVPotControlById(int id) {
        return this.vpots[this.vpotIndexMap.get(id)];
    }

    @Override
    public MCUButtonControl getButtonControl(int i) {
        return this.keys[i];
    }

    @Override
    protected MCUButtonControl getButtonControlById(int id) {
        return this.keys[this.keyIndexMap.get(id)];
    }

    @Override
    public MCUFaderControl getFaderControl(int i) {
        return this.fader;
    }

    @Override
    protected MCUFaderControl getFaderControlById(int id) {
        return this.fader;
    }

    @Override
    public int getNumVPotControls() {
        return this.vpotIds.length;
    }

    @Override
    public int getNumButtonControls() {
        return this.vpotIds.length;
    }

    @Override
    public int getNumFaderControls() {
        return this.vpotIds.length;
    }

    public void reset() throws InterruptedException, InvalidMidiDataException {
        ShortMessage msg = new ShortMessage(255);
        this.send(msg);
        msg.setMessage(176, 127, 1);
        this.send(176, 127, 1);
        for (MCUVPotControl mCUVPotControl : this.vpots) {
            mCUVPotControl.display();
        }
        for (MCUControl mCUControl : this.keys) {
            ((MCUButtonControl)mCUControl).display();
        }
    }

    public static XTouchMiniMCUControlPanel build(String deviceDescription) throws InvalidMidiDataException, MidiUnavailableException, InterruptedException {
        MidiDevice transDev = null;
        Transmitter trans = null;
        MidiDevice recDev = null;
        Receiver rec = null;
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            MidiDevice device = MidiSystem.getMidiDevice(info);
            System.out.println(info.getName() + " : " + info.getDescription());
            String lowerDeviceDescription = deviceDescription.toLowerCase();
            if (!info.getDescription().toLowerCase().contains(lowerDeviceDescription) && !info.getName().toLowerCase().contains(lowerDeviceDescription)) continue;
            if (device.getMaxTransmitters() != 0) {
                transDev = device;
                trans = device.getTransmitter();
            }
            if (device.getMaxReceivers() == 0) continue;
            recDev = device;
            rec = device.getReceiver();
        }
        if (trans != null && rec != null) {
            transDev.open();
            recDev.open();
            XTouchMiniMCUControlPanel panel = new XTouchMiniMCUControlPanel(trans, rec);
            trans.setReceiver(panel);
            panel.reset();
            return panel;
        }
        if (transDev != null) {
            transDev.close();
        }
        if (recDev != null) {
            recDev.close();
        }
        throw new MidiUnavailableException("No X TOUCH mini MIDI controller found.");
    }

    public static XTouchMiniMCUControlPanel build() throws InvalidMidiDataException, MidiUnavailableException, InterruptedException {
        return XTouchMiniMCUControlPanel.build(DEFAULT_DEVICE_DESCRIPTION);
    }

    public static void main(String ... args) throws InvalidMidiDataException, MidiUnavailableException, InterruptedException {
        XTouchMiniMCUControlPanel.build();
    }
}

