/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import bdv.util.RandomAccessibleIntervalMipmapSource;
import bdv.viewer.Source;
import java.util.Arrays;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;

public class MultiscaleDatasets {
    private final String[] paths;
    private final AffineTransform3D[] transforms;
    private AffineTransform3D sourceTransform;
    private String unit;

    public MultiscaleDatasets(String[] paths, AffineTransform3D[] transforms, String unit) {
        this.paths = paths;
        this.transforms = transforms;
        this.unit = unit;
    }

    public MultiscaleDatasets(String[] paths, AffineTransform3D[] transforms) {
        this(paths, transforms, "pixel");
    }

    public MultiscaleDatasets(ScaleLevel[] scales) {
        int N = scales.length;
        this.paths = new String[N];
        this.transforms = new AffineTransform3D[N];
        for (int i = 0; i < N; ++i) {
            this.paths[i] = scales[i].path;
            this.transforms[i] = scales[i].transform;
        }
    }

    public void setTransform(AffineTransform3D transform) {
        this.sourceTransform = transform;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public AffineTransform3D[] getTransforms() {
        return this.transforms;
    }

    public <T extends NumericType<T>> Source<T> openAsSource(N5Reader n5, boolean isVolatile, String name) {
        RandomAccessibleInterval[] images = new RandomAccessibleInterval[this.paths.length];
        double[][] mipmapScales = new double[images.length][3];
        for (int s = 0; s < images.length; ++s) {
            try {
                images[s] = isVolatile ? N5Utils.openVolatile((N5Reader)n5, (String)this.paths[s]) : N5Utils.open((N5Reader)n5, (String)this.paths[s]);
            }
            catch (N5Exception e) {
                e.printStackTrace();
            }
            mipmapScales[s][0] = this.transforms[s].get(0, 0);
            mipmapScales[s][1] = this.transforms[s].get(1, 1);
            mipmapScales[s][2] = this.transforms[s].get(2, 2);
        }
        RandomAccessibleIntervalMipmapSource source = new RandomAccessibleIntervalMipmapSource(images, (NumericType)Util.getTypeFromInterval((Interval)images[0]), mipmapScales, (VoxelDimensions)new FinalVoxelDimensions(this.unit, mipmapScales[0]), this.sourceTransform == null ? new AffineTransform3D() : this.sourceTransform, name);
        return source;
    }

    public static MultiscaleDatasets sort(String[] paths, AffineTransform3D[] transforms) {
        assert (paths.length == transforms.length);
        int N = paths.length;
        Object[] scales = new ScaleLevel[N];
        for (int i = 0; i < N; ++i) {
            scales[i] = new ScaleLevel(paths[i], transforms[i]);
        }
        Arrays.sort(scales);
        return new MultiscaleDatasets((ScaleLevel[])scales);
    }

    public static class ScaleLevel
    implements Comparable<ScaleLevel> {
        public final String path;
        public final AffineTransform3D transform;
        public final double averageScale;

        public ScaleLevel(String path, AffineTransform3D transform) {
            this.path = path;
            this.transform = transform;
            this.averageScale = (transform.get(0, 0) + transform.get(1, 1) + transform.get(2, 2)) / 3.0;
        }

        public String toString() {
            return this.path + " (" + this.averageScale + ")";
        }

        @Override
        public int compareTo(ScaleLevel o) {
            if (this.averageScale == o.averageScale) {
                return 0;
            }
            if (this.averageScale < o.averageScale) {
                return -1;
            }
            return 1;
        }
    }
}

