/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.TypedAxis;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.display.imagej.CalibrationUtils;
import net.imglib2.img.display.imagej.ImageProcessorUtils;
import net.imglib2.img.display.imagej.ImgPlusViews;
import net.imglib2.type.NativeType;

public class ArrayImgToVirtualStack {
    private ArrayImgToVirtualStack() {
    }

    public static boolean isSupported(ImgPlus<?> imgPlus) {
        return (imgPlus = ImgPlusViews.fixAxes(imgPlus)).getImg() instanceof ArrayImg && imgPlus.numDimensions() == 2 && ArrayImgToVirtualStack.checkAxis(ArrayImgToVirtualStack.getAxes(imgPlus)) && ImageProcessorUtils.isSupported((NativeType)imgPlus.randomAccess().get());
    }

    public static ImagePlus wrap(ImgPlus<?> imgPlus) {
        Img img = (imgPlus = ImgPlusViews.fixAxes(imgPlus)).getImg();
        if (!(img instanceof ArrayImg)) {
            throw new IllegalArgumentException("Expecting ArrayImg");
        }
        ArrayImg arrayImg = (ArrayImg)img;
        int sizeX = (int)img.dimension(0);
        int sizeY = (int)img.dimension(1);
        Object pixels = ((ArrayDataAccess)arrayImg.update(null)).getCurrentStorageArray();
        ImageProcessor processor = ImageProcessorUtils.createImageProcessor(pixels, sizeX, sizeY, null);
        ImagePlus imagePlus = new ImagePlus(imgPlus.getName(), processor);
        CalibrationUtils.copyCalibrationToImagePlus(imgPlus, imagePlus);
        return imagePlus;
    }

    private static boolean checkAxis(List<AxisType> axes) {
        return axes.size() == 2 && axes.get(0) == Axes.X && axes.get(1) == Axes.Y;
    }

    private static List<AxisType> getAxes(ImgPlus<?> img) {
        return IntStream.range(0, img.numDimensions()).mapToObj(arg_0 -> img.axis(arg_0)).map(TypedAxis::type).collect(Collectors.toList());
    }
}

