/*
 * Decompiled with CFR 0.152.
 */
package fiji.packaging;

import fiji.packaging.TarPackager;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;

public class TarBz2Packager
extends TarPackager {
    protected Constructor<OutputStream> ctor;

    public TarBz2Packager() throws ClassNotFoundException {
        Class<?> clazz = this.getClass().getClassLoader().loadClass("org.apache.tools.bzip2.CBZip2OutputStream");
        try {
            this.ctor = clazz.getConstructor(OutputStream.class);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException("Incompatible CBZip2OutputStream");
        }
    }

    @Override
    public String getExtension() {
        return ".tar.bz2";
    }

    @Override
    public void open(OutputStream out) throws IOException {
        try {
            out.write("BZ".getBytes());
            this.out = this.ctor.newInstance(out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

