/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.download;

import java.io.File;
import java.io.IOException;
import org.scijava.download.LocationCache;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.util.DigestUtils;
import org.scijava.util.FileUtils;

public class DiskLocationCache
implements LocationCache {
    private File baseDir = new File(System.getProperty("user.home") + File.separator + ".scijava" + File.separator + "cache" + File.separator);
    private boolean cacheFileLocations;

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File baseDir) {
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + baseDir);
        }
        this.baseDir = baseDir;
    }

    public boolean isFileLocationCachingEnabled() {
        return this.cacheFileLocations;
    }

    public void setFileLocationCachingEnabled(boolean enabled) {
        this.cacheFileLocations = enabled;
    }

    @Override
    public boolean canCache(Location source) {
        if (source instanceof FileLocation && !this.isFileLocationCachingEnabled()) {
            return false;
        }
        return source.getURI() != null;
    }

    @Override
    public Location cachedLocation(Location source) {
        if (!this.canCache(source)) {
            throw new IllegalArgumentException("Uncacheable source: " + source);
        }
        return new FileLocation(this.cachedData(source));
    }

    @Override
    public String loadChecksum(Location source) throws IOException {
        File cachedChecksum = this.cachedChecksum(source);
        if (!cachedChecksum.exists()) {
            return null;
        }
        return DigestUtils.string(FileUtils.readFile(cachedChecksum));
    }

    @Override
    public void saveChecksum(Location source, String checksum) throws IOException {
        File cachedChecksum = this.cachedChecksum(source);
        FileUtils.writeFile(cachedChecksum, DigestUtils.bytes(checksum));
    }

    private File cachedData(Location source) {
        return this.cachedFile(source, ".data");
    }

    private File cachedChecksum(Location source) {
        return this.cachedFile(source, ".checksum");
    }

    private File cachedFile(Location source, String suffix) {
        String hexCode = Integer.toHexString(source.hashCode());
        return new File(this.getBaseDirectory(), hexCode + suffix);
    }
}

