/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.thread;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public final class DefaultThreadService
extends AbstractService
implements ThreadService {
    private static final String SCIJAVA_THREAD_PREFIX = "SciJava-";
    private static final long SHUTDOWN_TIMEOUT = 5000L;
    private static WeakHashMap<Thread, Thread> parents = new WeakHashMap();
    @Parameter
    private LogService log;
    private ExecutorService executor;
    private Map<String, ExecutorService> queues;
    private int nextThread = 0;
    private boolean disposed;

    @Override
    public <V> Future<V> run(Callable<V> code) {
        if (this.disposed) {
            return null;
        }
        return this.executor().submit(this.wrap(code));
    }

    @Override
    public Future<?> run(Runnable code) {
        if (this.disposed) {
            return null;
        }
        return this.executor().submit(this.wrap(code));
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executor();
    }

    @Override
    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void invoke(Runnable code) throws InterruptedException, InvocationTargetException {
        if (this.isDispatchThread()) {
            code.run();
        } else {
            EventQueue.invokeAndWait(this.wrap(code));
        }
    }

    @Override
    public void queue(Runnable code) {
        EventQueue.invokeLater(this.wrap(code));
    }

    @Override
    public Future<?> queue(String id, Runnable code) {
        return this.executor(id).submit(this.wrap(code));
    }

    @Override
    public <V> Future<V> queue(String id, Callable<V> code) {
        return this.executor(id).submit(this.wrap(code));
    }

    @Override
    public Thread getParent(Thread thread) {
        return parents.get(thread != null ? thread : Thread.currentThread());
    }

    @Override
    public ThreadService.ThreadContext getThreadContext(Thread thread) {
        String name = thread.getName();
        if (name.startsWith(this.contextThreadPrefix())) {
            return ThreadService.ThreadContext.SAME;
        }
        if (name.startsWith(SCIJAVA_THREAD_PREFIX)) {
            return ThreadService.ThreadContext.OTHER;
        }
        Thread parent = this.getParent(thread);
        if (parent == thread || parent == null) {
            return ThreadService.ThreadContext.NONE;
        }
        return this.getThreadContext(parent);
    }

    @Override
    public synchronized void dispose() {
        this.disposed = true;
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException exc) {
                this.log.debug(exc);
            }
            this.executor = null;
        }
        if (this.queues != null) {
            for (ExecutorService queue : this.queues.values()) {
                queue.shutdown();
                try {
                    queue.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException exc) {
                    this.log.debug(exc);
                }
            }
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        String threadName = this.contextThreadPrefix() + this.nextThread++;
        Thread thread = new Thread(r, threadName);
        thread.setDaemon(true);
        return thread;
    }

    private ExecutorService executor() {
        if (this.executor == null) {
            this.initExecutor();
        }
        return this.executor;
    }

    private synchronized ExecutorService executor(String id) {
        if (this.disposed) {
            return null;
        }
        if (this.queues == null) {
            this.queues = new HashMap<String, ExecutorService>();
        }
        if (!this.queues.containsKey(id)) {
            ThreadFactory factory = r -> {
                String threadName = this.contextThreadPrefix() + id;
                return new Thread(r, threadName);
            };
            ExecutorService queue = Executors.newSingleThreadExecutor(factory);
            this.queues.put(id, queue);
        }
        return this.queues.get(id);
    }

    private synchronized void initExecutor() {
        if (this.executor != null) {
            return;
        }
        this.executor = Executors.newCachedThreadPool(this);
    }

    private Runnable wrap(Runnable r) {
        Thread parent = Thread.currentThread();
        return () -> {
            Thread thread = Thread.currentThread();
            try {
                if (parent != thread) {
                    parents.put(thread, parent);
                }
                r.run();
            }
            finally {
                if (parent != thread) {
                    parents.remove(thread);
                }
            }
        };
    }

    private <V> Callable<V> wrap(Callable<V> c) {
        Thread parent = Thread.currentThread();
        return () -> {
            Thread thread = Thread.currentThread();
            try {
                if (parent != thread) {
                    parents.put(thread, parent);
                }
                Object v = c.call();
                return v;
            }
            finally {
                if (parent != thread) {
                    parents.remove(thread);
                }
            }
        };
    }

    private String contextThreadPrefix() {
        String contextHash = Integer.toHexString(this.context().hashCode());
        return SCIJAVA_THREAD_PREFIX + contextHash + "-Thread-";
    }
}

