/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;

public interface IntensityMetadata
extends N5DatasetMetadata {
    public static double maxForDataType(DataType dataType) {
        switch (dataType) {
            case UINT8: {
                return 255.0;
            }
            case UINT16: {
                return 65535.0;
            }
            case UINT32: {
                return 4.294967295E9;
            }
            case UINT64: {
                return 1.8446744073709552E19;
            }
            case INT8: {
                return 127.0;
            }
            case INT16: {
                return 32767.0;
            }
            case INT32: {
                return 2.147483647E9;
            }
            case INT64: {
                return 9.223372036854776E18;
            }
        }
        return 1.0;
    }

    default public double minIntensity() {
        return 0.0;
    }

    default public double maxIntensity() {
        return IntensityMetadata.maxForDataType(this.getAttributes().getDataType());
    }
}

