/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataGroup;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.TransformUtils;

public interface SpatialMetadataGroup<T extends SpatialMetadata>
extends N5MetadataGroup<T>,
SpatialMetadata {
    default public AffineGet[] spatialTransforms() {
        return (AffineGet[])Arrays.stream(this.getChildrenMetadata()).map(SpatialMetadata::spatialTransform).toArray(AffineGet[]::new);
    }

    public String[] units();

    default public AffineTransform3D[] spatialTransforms3d() {
        ArrayList<AffineTransform3D> transforms = new ArrayList<AffineTransform3D>();
        for (AffineGet transform : this.spatialTransforms()) {
            if (transform == null) {
                transforms.add(new AffineTransform3D());
                continue;
            }
            if (transform instanceof AffineTransform3D) {
                transforms.add((AffineTransform3D)transform);
                continue;
            }
            if (transform.numSourceDimensions() == 3) {
                AffineTransform3D affine3d = new AffineTransform3D();
                affine3d.set(transform.getRowPackedCopy());
                transforms.add(affine3d);
                continue;
            }
            if (transform.numSourceDimensions() == 2) {
                transforms.add((AffineTransform3D)TransformUtils.superAffine(transform, 3, new int[]{0, 1}));
                continue;
            }
            if (((SpatialMetadata[])this.getChildrenMetadata())[0] instanceof AxisMetadata) {
                AxisMetadata ax = (AxisMetadata)((Object)((SpatialMetadata[])this.getChildrenMetadata())[0]);
                transforms.add(TransformUtils.spatialTransform3D(transform, ax.getAxes()));
                continue;
            }
            int[] indexes = new int[]{0, 1, 2};
            transforms.add(TransformUtils.spatialTransform3D(transform, indexes));
        }
        return (AffineTransform3D[])transforms.stream().map(AffineTransform3D::copy).toArray(AffineTransform3D[]::new);
    }

    @Override
    default public AffineGet spatialTransform() {
        return ((SpatialMetadata[])this.getChildrenMetadata())[0].spatialTransform();
    }

    @Override
    default public String unit() {
        return ((SpatialMetadata[])this.getChildrenMetadata())[0].unit();
    }

    @Override
    default public AffineTransform3D spatialTransform3d() {
        return ((SpatialMetadata[])this.getChildrenMetadata())[0].spatialTransform3d();
    }
}

